/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.ApplyRDFS;
import org.apache.jena.rdfs.engine.Mappers;
import org.apache.jena.rdfs.engine.Output;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.Quad;

public class InfStreamRDFS
extends StreamRDFWrapper {
    private final ConfigRDFS<Node> rdfsSetup;
    private final ApplyRDFS<Node, Triple> rdfs;
    private final Output<Node> outputTriple;
    private final boolean includeInput = true;
    private Node currentGraph;
    private Output<Node> currentGraphOutput;

    public InfStreamRDFS(StreamRDF output, ConfigRDFS<Node> rdfsSetup) {
        super(output);
        this.rdfsSetup = rdfsSetup;
        this.outputTriple = (s2, p, o) -> output.triple(Triple.create(s2, p, o));
        this.rdfs = new ApplyRDFS<Node, Triple>(rdfsSetup, Mappers.mapperTriple());
    }

    @Override
    public void triple(Triple triple) {
        super.triple(triple);
        this.rdfs.infer(triple.getSubject(), triple.getPredicate(), triple.getObject(), this.outputTriple);
    }

    @Override
    public void quad(Quad quad) {
        super.quad(quad);
        if (this.currentGraph != quad.getGraph()) {
            this.currentGraph = quad.getGraph();
            this.currentGraphOutput = (s2, p, o) -> Quad.create(this.currentGraph, s2, p, o);
        }
        this.rdfs.infer(quad.getSubject(), quad.getPredicate(), quad.getObject(), this.currentGraphOutput);
    }
}

