/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.pattern;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem2.pattern.MatchPattern;

public class PatternClassifier {
    private PatternClassifier() {
    }

    public static MatchPattern classify(Triple tripleMatch) {
        if (tripleMatch.isConcrete()) {
            return MatchPattern.SUB_PRE_OBJ;
        }
        if (tripleMatch.getSubject().isConcrete()) {
            if (tripleMatch.getPredicate().isConcrete()) {
                return MatchPattern.SUB_PRE_ANY;
            }
            if (tripleMatch.getObject().isConcrete()) {
                return MatchPattern.SUB_ANY_OBJ;
            }
            return MatchPattern.SUB_ANY_ANY;
        }
        if (tripleMatch.getPredicate().isConcrete()) {
            if (tripleMatch.getObject().isConcrete()) {
                return MatchPattern.ANY_PRE_OBJ;
            }
            return MatchPattern.ANY_PRE_ANY;
        }
        if (tripleMatch.getObject().isConcrete()) {
            return MatchPattern.ANY_ANY_OBJ;
        }
        return MatchPattern.ANY_ANY_ANY;
    }

    public static MatchPattern classify(Node sm, Node pm, Node om) {
        if (null != sm && sm.isConcrete()) {
            if (null != pm && pm.isConcrete()) {
                if (null != om && om.isConcrete()) {
                    return MatchPattern.SUB_PRE_OBJ;
                }
                return MatchPattern.SUB_PRE_ANY;
            }
            if (null != om && om.isConcrete()) {
                return MatchPattern.SUB_ANY_OBJ;
            }
            return MatchPattern.SUB_ANY_ANY;
        }
        if (null != pm && pm.isConcrete()) {
            if (null != om && om.isConcrete()) {
                return MatchPattern.ANY_PRE_OBJ;
            }
            return MatchPattern.ANY_PRE_ANY;
        }
        if (null != om && om.isConcrete()) {
            return MatchPattern.ANY_ANY_OBJ;
        }
        return MatchPattern.ANY_ANY_ANY;
    }
}

