/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.auth.AuthChallenge;
import org.apache.jena.http.auth.AuthCredentials;
import org.apache.jena.http.auth.AuthDomain;
import org.apache.jena.http.auth.AuthLib;
import org.apache.jena.http.auth.AuthRequestModifier;
import org.apache.jena.http.auth.PasswordRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthEnv {
    public static Logger LOG = LoggerFactory.getLogger(AuthEnv.class);
    private AuthCredentials passwordRegistry = new AuthCredentials();
    private Map<String, AuthRequestModifier> authModifiers = new ConcurrentHashMap<String, AuthRequestModifier>();
    private BiFunction<String, AuthChallenge, String> tokenSupplier = null;
    private static AuthEnv singleton = new AuthEnv();

    public static AuthEnv get() {
        return singleton;
    }

    private AuthEnv() {
    }

    public void registerUsernamePassword(String uri, String username, String password) {
        this.registerUsernamePassword(URI.create(uri), username, password);
    }

    public void registerUsernamePassword(URI uri, String username, String password) {
        AuthDomain domain = new AuthDomain(uri);
        this.passwordRegistry.put(domain, new PasswordRecord(username, password));
        this.authModifiers.remove(uri.toString());
    }

    public boolean hasRegistation(URI uri) {
        AuthDomain location = new AuthDomain(uri);
        return this.passwordRegistry.contains(location);
    }

    public void unregisterUsernamePassword(URI uri) {
        AuthDomain location = new AuthDomain(uri);
        this.passwordRegistry.remove(location);
        String uristr = uri.toString();
        ArrayList<String> removes = new ArrayList<String>();
        for (Map.Entry<String, AuthRequestModifier> e2 : this.authModifiers.entrySet()) {
            String key = e2.getKey();
            if (!key.startsWith(uristr)) continue;
            removes.add(key);
        }
        removes.forEach(k -> this.authModifiers.remove(k));
    }

    public PasswordRecord getUsernamePassword(URI uri) {
        AuthDomain domain = new AuthDomain(uri);
        return this.passwordRegistry.get(domain);
    }

    public void clearActiveAuthentication() {
        this.authModifiers.clear();
    }

    public void clearAuthEnv() {
        this.passwordRegistry.clearAll();
        this.authModifiers.clear();
    }

    public HttpRequest.Builder addAuth(HttpRequest.Builder requestBuilder, String uri) {
        if (this.authModifiers.isEmpty()) {
            return requestBuilder;
        }
        String endpointURL = HttpLib.endpoint(uri);
        AuthRequestModifier mod = this.authModifiers.get(endpointURL);
        if (mod == null) {
            return requestBuilder;
        }
        return mod.addAuth(requestBuilder);
    }

    public void registerBasicAuthModifier(String url, String user, String password) {
        AuthRequestModifier basicAuthModifier = AuthLib.basicAuthModifier(user, password);
        String serviceEndpoint = HttpLib.endpoint(url);
        this.authModifiers.put(serviceEndpoint, basicAuthModifier);
    }

    public void registerAuthModifier(String requestTarget, AuthRequestModifier authModifier) {
        String serviceEndpoint = HttpLib.endpoint(requestTarget);
        this.authModifiers.put(serviceEndpoint, authModifier);
    }

    public void unregisterAuthModifier(String requestTarget) {
        String endpointURL = HttpLib.endpoint(requestTarget);
        AuthRequestModifier oldMod = this.authModifiers.remove(endpointURL);
    }

    public void setBearerTokenProvider(BiFunction<String, AuthChallenge, String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    public void setBearerToken(String requestTarget, String token) {
        if (token == null) {
            this.unregisterAuthModifier(requestTarget);
            return;
        }
        String endpointURL = HttpLib.endpoint(requestTarget);
        AuthRequestModifier authModifier = builder -> builder.setHeader("Authorization", "Bearer " + token);
        this.registerAuthModifier(requestTarget, authModifier);
    }

    public String getBearerToken(String uri, AuthChallenge aHeader) {
        if (this.tokenSupplier == null) {
            return null;
        }
        return this.tokenSupplier.apply(uri, aHeader);
    }

    public void state() {
        IndentedWriter out = IndentedWriter.stdout.clone();
        out.setFlushOnNewline(true);
        out.println("Password Registry");
        out.incIndent();
        this.passwordRegistry.registered().forEach(ad -> out.println(ad.getURI()));
        out.decIndent();
        out.println("Auth Modifiers");
        out.incIndent();
        this.authModifiers.forEach((uriStr, m4) -> out.println((String)uriStr));
        out.decIndent();
    }
}

