/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.fuseki.Fuseki;

public class AuthFilter
implements Filter {
    private final Predicate<String> predicate;

    public AuthFilter(Predicate<String> allowAccess) {
        this.predicate = allowAccess;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filter) throws IOException, ServletException {
        try {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String user = httpRequest.getRemoteUser();
            boolean allowed = this.predicate.test(user);
            if (!allowed) {
                httpResponse.sendError(403);
                return;
            }
            filter.doFilter(httpRequest, httpResponse);
        }
        catch (ClassCastException ex) {
            Fuseki.actionLog.error(ex.getMessage());
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}

