/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.micrometer.common.KeyValues;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationDocumentation;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.HttpContextUtils;
import java.io.IOException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;

public class DefaultApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final DefaultApacheHttpClientObservationConvention INSTANCE = new DefaultApacheHttpClientObservationConvention();

    protected DefaultApacheHttpClientObservationConvention() {
    }

    @Override
    public String getName() {
        return "httpcomponents.httpclient.request";
    }

    @Override
    public String getContextualName(ApacheHttpClientContext context2) {
        return "HTTP " + this.getMethodString((HttpRequest)context2.getCarrier());
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context2) {
        KeyValues keyValues = KeyValues.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD.withValue(this.getMethodString((HttpRequest)context2.getCarrier())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(context2.getUriMapper().apply((HttpRequest)context2.getCarrier())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS.withValue(this.getStatusValue((HttpResponse)context2.getResponse(), context2.getError())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME.withValue(this.getStatusOutcome((HttpResponse)context2.getResponse()).name()));
        if (context2.shouldExportTagsForRoute()) {
            keyValues = keyValues.and(HttpContextUtils.generateTagStringsForRoute(context2.getApacheHttpContext()));
        }
        return keyValues;
    }

    Outcome getStatusOutcome(@Nullable HttpResponse response) {
        return response != null ? Outcome.forStatus(response.getCode()) : Outcome.UNKNOWN;
    }

    String getStatusValue(@Nullable HttpResponse response, Throwable error) {
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return "IO_ERROR";
        }
        return response != null ? Integer.toString(response.getCode()) : "CLIENT_ERROR";
    }

    String getMethodString(@Nullable HttpRequest request) {
        return request != null && request.getMethod() != null ? request.getMethod() : "UNKNOWN";
    }
}

