/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DefaultsDescriptor;
import org.eclipse.jetty.webapp.OverrideDescriptor;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebXmlConfiguration.class);

    public WebXmlConfiguration() {
        this.addDependencies(WebInfConfiguration.class);
    }

    @Override
    public void preConfigure(WebAppContext context2) throws Exception {
        Resource webxml;
        String defaultsDescriptor = context2.getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                String pkg = WebXmlConfiguration.class.getPackageName().replace(".", "/") + "/";
                if (defaultsDescriptor.startsWith(pkg)) {
                    dftResource = Resource.newResource(WebXmlConfiguration.class.getResource(defaultsDescriptor.substring(pkg.length())));
                }
                if (dftResource == null) {
                    dftResource = context2.newResource(defaultsDescriptor);
                }
            }
            context2.getMetaData().setDefaultsDescriptor(new DefaultsDescriptor(dftResource));
        }
        if ((webxml = this.findWebXml(context2)) != null) {
            context2.getMetaData().setWebDescriptor(new WebDescriptor(webxml));
            context2.getServletContext().setEffectiveMajorVersion(context2.getMetaData().getWebDescriptor().getMajorVersion());
            context2.getServletContext().setEffectiveMinorVersion(context2.getMetaData().getWebDescriptor().getMinorVersion());
        }
        for (String overrideDescriptor : context2.getOverrideDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = Resource.newSystemResource(overrideDescriptor);
            if (orideResource == null) {
                orideResource = context2.newResource(overrideDescriptor);
            }
            context2.getMetaData().addOverrideDescriptor(new OverrideDescriptor(orideResource));
        }
    }

    @Override
    public void configure(WebAppContext context2) throws Exception {
        context2.getMetaData().addDescriptorProcessor(new StandardDescriptorProcessor());
    }

    protected Resource findWebXml(WebAppContext context2) throws IOException, MalformedURLException {
        Resource web;
        String descriptor = context2.getDescriptor();
        if (descriptor != null && (web = context2.newResource(descriptor)).exists() && !web.isDirectory()) {
            return web;
        }
        Resource webInf = context2.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource web2 = webInf.addPath("web.xml");
            if (web2.exists()) {
                return web2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No WEB-INF/web.xml in {}. Serving files and default/dynamic servlets only", (Object)context2.getWar());
            }
        }
        return null;
    }

    @Override
    public void deconfigure(WebAppContext context2) throws Exception {
        context2.setWelcomeFiles(null);
        if (context2.getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)context2.getErrorHandler()).setErrorPages(null);
        }
    }
}

