/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.lib;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.lib.ColumnMap;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;

public class TupleLib {
    public static Iterator<Tuple<Node>> convertToNodes(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.tupleNodes(nodeTable, item));
    }

    public static Iterator<Tuple<NodeId>> convertToNodeId(NodeTable nodeTable, Iterator<Tuple<Node>> iter) {
        return Iter.map(iter, item -> TupleLib.tupleNodeIds(nodeTable, item));
    }

    public static Iterator<Triple> convertToTriples(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.triple(nodeTable, item));
    }

    public static Iterator<Quad> convertToQuads(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.quad(nodeTable, item));
    }

    public static Tuple<Node> tupleNodes(NodeTable nodeTable, Tuple<NodeId> ids) {
        return ids.map(nid -> nodeTable.getNodeForNodeId((NodeId)nid));
    }

    public static Tuple<NodeId> tupleNodeIds(NodeTable nodeTable, Tuple<Node> nodes) {
        return nodes.map(n -> nodeTable.getNodeIdForNode((Node)n));
    }

    private static Triple triple(NodeTable nodeTable, Tuple<NodeId> tuple) {
        if (tuple.len() != 3) {
            throw new TDBException("Tuple is not of length 3: " + tuple);
        }
        return TupleLib.triple(nodeTable, tuple.get(0), tuple.get(1), tuple.get(2));
    }

    private static Triple triple(NodeTable nodeTable, NodeId s2, NodeId p, NodeId o) {
        if (!NodeId.isConcrete(s2)) {
            throw new InternalErrorException("Invalid id for subject: " + TupleLib.fmt(s2, p, o));
        }
        if (!NodeId.isConcrete(p)) {
            throw new InternalErrorException("Invalid id for predicate: " + TupleLib.fmt(s2, p, o));
        }
        if (!NodeId.isConcrete(o)) {
            throw new InternalErrorException("Invalid id for object: " + TupleLib.fmt(s2, p, o));
        }
        Node sNode = nodeTable.getNodeForNodeId(s2);
        if (sNode == null) {
            throw new InternalErrorException("Invalid id node for subject (null node): " + TupleLib.fmt(s2, p, o));
        }
        Node pNode = nodeTable.getNodeForNodeId(p);
        if (pNode == null) {
            throw new InternalErrorException("Invalid id node for predicate (null node): " + TupleLib.fmt(s2, p, o));
        }
        Node oNode = nodeTable.getNodeForNodeId(o);
        if (oNode == null) {
            throw new InternalErrorException("Invalid id node for object (null node): " + TupleLib.fmt(s2, p, o));
        }
        return Triple.create(sNode, pNode, oNode);
    }

    private static String fmt(NodeId s2, NodeId p, NodeId o) {
        return "(" + s2 + ", " + p + ", " + o + ")";
    }

    private static String fmt(NodeId g2, NodeId s2, NodeId p, NodeId o) {
        return "(" + g2 + "," + s2 + ", " + p + ", " + o + ")";
    }

    private static Quad quad(NodeTable nodeTable, Tuple<NodeId> tuple) {
        if (tuple.len() != 4) {
            throw new TDBException("Tuple is not of length 4: " + tuple);
        }
        return TupleLib.quad(nodeTable, tuple.get(0), tuple.get(1), tuple.get(2), tuple.get(3));
    }

    private static Quad quad(NodeTable nodeTable, NodeId g2, NodeId s2, NodeId p, NodeId o) {
        Node gNode = nodeTable.getNodeForNodeId(g2);
        Node sNode = nodeTable.getNodeForNodeId(s2);
        Node pNode = nodeTable.getNodeForNodeId(p);
        Node oNode = nodeTable.getNodeForNodeId(o);
        if (gNode == null) {
            throw new InternalErrorException("Invalid id node for graph (null node): " + TupleLib.fmt(g2, s2, p, o));
        }
        if (sNode == null) {
            throw new InternalErrorException("Invalid id node for subject (null node): " + TupleLib.fmt(g2, s2, p, o));
        }
        if (pNode == null) {
            throw new InternalErrorException("Invalid id node for predicate (null node): " + TupleLib.fmt(g2, s2, p, o));
        }
        if (oNode == null) {
            throw new InternalErrorException("Invalid id node for object (null node): " + TupleLib.fmt(g2, s2, p, o));
        }
        return Quad.create(gNode, sNode, pNode, oNode);
    }

    public static Tuple<NodeId> tuple(Record r, ColumnMap cMap) {
        int N2 = r.getKey().length / 8;
        NodeId[] nodeIds = new NodeId[N2];
        for (int i = 0; i < N2; ++i) {
            NodeId id = NodeId.create(r.getKey(), i * 8);
            int j = i;
            if (cMap != null) {
                j = cMap.fetchSlotIdx(i);
            }
            nodeIds[j] = id;
        }
        return TupleFactory.asTuple(nodeIds);
    }

    public static Record record(RecordFactory factory, Tuple<NodeId> tuple, ColumnMap cMap) {
        byte[] b = new byte[tuple.len() * 8];
        for (int i = 0; i < tuple.len(); ++i) {
            int j = cMap.mapSlotIdx(i);
            Bytes.setLong(tuple.get(i).getId(), b, j * 8);
        }
        return factory.create(b);
    }
}

