/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.update.Update;

public class UpdateLoad
extends Update {
    private final String source;
    private final Node dest;
    private boolean silent;

    public UpdateLoad(String source, String dest) {
        this(source, NodeFactory.createURI(dest), false);
    }

    public UpdateLoad(String source, String dest, boolean silent) {
        this(source, NodeFactory.createURI(dest), silent);
    }

    public UpdateLoad(String source, Node dest) {
        this(source, dest, false);
    }

    public UpdateLoad(String source, Node dest, boolean silent) {
        this.source = source;
        this.dest = dest;
        this.silent = silent;
    }

    public String getSource() {
        return this.source;
    }

    public Node getDest() {
        return this.dest;
    }

    @Deprecated
    public boolean getSilent() {
        return this.isSilent();
    }

    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public void visit(UpdateVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equalTo(Update obj, NodeIsomorphismMap isoMap) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateLoad other = (UpdateLoad)obj;
        return this.silent == other.silent && Objects.equals(this.source, other.source) && Iso.nodeIso(this.dest, other.dest, isoMap);
    }
}

