/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.lib.Alarm;
import org.apache.jena.atlas.lib.AlarmClock;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.describe.DescribeHandler;
import org.apache.jena.sparql.core.describe.DescribeHandlerRegistry;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.exec.JsonResults;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;

public class QueryExecDataset
implements QueryExec {
    private final Query query;
    private String queryString = null;
    private final QueryEngineFactory qeFactory;
    private final Context context;
    private final DatasetGraph dataset;
    private QueryIterator queryIterator = null;
    private Plan plan = null;
    private Binding initialBinding = null;
    private boolean closed;
    private AtomicReference<TimeoutCallback> expectedCallback = new AtomicReference<Object>(null);
    private Alarm timeout1Alarm = null;
    private Alarm timeout2Alarm = null;
    private final Object lockTimeout = new Object();
    private static final long TIMEOUT_UNSET = -1L;
    private static final long TIMEOUT_INF = -2L;
    private long timeout1 = -1L;
    private long timeout2 = -1L;
    private final AlarmClock alarmClock = AlarmClock.get();
    private long queryStartTime = -1L;

    public static QueryExecDatasetBuilder newBuilder() {
        return QueryExecDatasetBuilder.create();
    }

    protected QueryExecDataset(Query query2, String queryString, DatasetGraph datasetGraph, Context cxt, QueryEngineFactory qeFactory, long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2, Binding initialToEngine) {
        this.query = query2;
        this.queryString = queryString;
        this.dataset = datasetGraph;
        this.qeFactory = qeFactory;
        this.context = cxt == null ? Context.setupContextForDataset(cxt, datasetGraph) : cxt;
        this.timeout1 = QueryExecDataset.asMillis(timeout1, timeUnit1);
        this.timeout2 = QueryExecDataset.asMillis(timeout2, timeUnit2);
        this.initialBinding = initialToEngine;
        this.init();
    }

    private void init() {
        Context.setCurrentDateTime(this.context);
        if (this.query != null) {
            this.context.put(ARQConstants.sysCurrentQuery, this.query);
        }
    }

    private static long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.queryIterator != null) {
            this.queryIterator.close();
        }
        if (this.plan != null) {
            this.plan.close();
        }
        if (this.timeout1Alarm != null) {
            this.alarmClock.cancel(this.timeout1Alarm);
        }
        if (this.timeout2Alarm != null) {
            this.alarmClock.cancel(this.timeout2Alarm);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new QueryExecException("HTTP QueryExecution has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.lockTimeout;
        synchronized (object) {
            if (this.queryIterator != null) {
                this.queryIterator.cancel();
            }
        }
    }

    @Override
    public RowSet select() {
        this.checkNotClosed();
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have RowSet from a " + QueryExecDataset.labelForQuery(this.query) + " query");
        }
        RowSet rowSet = this.execute();
        return rowSet;
    }

    private RowSet execute() {
        this.execInit();
        this.startQueryIterator();
        QueryIterator iter = this.queryIterator;
        List<Var> vars = this.query.getResultVars().stream().map(Var::alloc).collect(Collectors.toList());
        return RowSetStream.create(vars, iter);
    }

    @Override
    public Graph construct(Graph graph) {
        this.checkNotClosed();
        try {
            Iterator<Triple> it = this.constructTriples();
            this.insertPrefixesInto(graph);
            GraphOps.addAll(graph, it);
        }
        finally {
            this.close();
        }
        return graph;
    }

    @Override
    public Iterator<Triple> constructTriples() {
        this.checkNotClosed();
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryExecDataset.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.startQueryIterator();
        Template template = this.query.getConstructTemplate();
        return TemplateLib.calcTriples(template.getTriples(), this.queryIterator);
    }

    @Override
    public Iterator<Quad> constructQuads() {
        this.checkNotClosed();
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryExecDataset.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.startQueryIterator();
        Template template = this.query.getConstructTemplate();
        return TemplateLib.calcQuads(template.getQuads(), this.queryIterator);
    }

    @Override
    public DatasetGraph constructDataset(DatasetGraph dataset) {
        try {
            Iterator<Quad> iter = this.constructQuads();
            iter.forEachRemaining(dataset::add);
            Iter.close(iter);
            this.insertPrefixesInto(dataset);
        }
        finally {
            this.close();
        }
        return dataset;
    }

    @Override
    public Graph describe(Graph graph) {
        this.checkNotClosed();
        Model model = ModelFactory.createModelForGraph(graph);
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryExecDataset.labelForQuery(this.query) + " query");
        }
        this.query.setResultVars();
        if (this.query.getQueryPattern() == null) {
            this.query.setQueryPattern(new ElementGroup());
        }
        HashSet set = new HashSet();
        RowSet rows = this.execute();
        this.insertPrefixesInto(graph);
        if (rows != null) {
            rows.forEachRemaining(row -> {
                for (Var var : rows.getResultVars()) {
                    Node n = row.get(var);
                    if (n == null) continue;
                    set.add(n);
                }
            });
        }
        if (this.query.getResultURIs() != null) {
            this.query.getResultURIs().forEach(set::add);
        }
        List<DescribeHandler> dhList = DescribeHandlerRegistry.get().newHandlerList();
        this.getContext().put(ARQConstants.sysCurrentDataset, this.getDataset());
        for (DescribeHandler dh : dhList) {
            dh.start(model, this.getContext());
        }
        for (Node n : set) {
            RDFNode rdfNode = ModelUtils.convertGraphNodeToRDFNode(n, model);
            if (!(rdfNode instanceof Resource)) continue;
            for (DescribeHandler dh : dhList) {
                dh.describe((Resource)rdfNode);
            }
        }
        for (DescribeHandler dh : dhList) {
            dh.finish();
        }
        this.close();
        return graph;
    }

    @Override
    public Iterator<Triple> describeTriples() {
        return this.describe().find();
    }

    @Override
    public boolean ask() {
        boolean r;
        this.checkNotClosed();
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryExecDataset.labelForQuery(this.query) + " query");
        }
        this.startQueryIterator();
        try {
            this.queryIterator.next();
            r = true;
        }
        catch (NoSuchElementException ex) {
            r = false;
        }
        finally {
            this.close();
        }
        return r;
    }

    @Override
    public JsonArray execJson() {
        this.checkNotClosed();
        if (!this.query.isJsonType()) {
            throw new QueryExecException("Attempt to get a JSON result from a " + QueryExecDataset.labelForQuery(this.query) + " query");
        }
        this.startQueryIterator();
        JsonArray jsonArray = JsonResults.results(this.queryIterator, this.query.getJsonMapping());
        List<String> resultVars = this.query.getResultVars();
        return jsonArray;
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        this.checkNotClosed();
        if (!this.query.isJsonType()) {
            throw new QueryExecException("Attempt to get a JSON result from a " + QueryExecDataset.labelForQuery(this.query) + " query");
        }
        this.startQueryIterator();
        return JsonResults.iterator(this.queryIterator, this.query.getJsonMapping());
    }

    private static boolean isTimeoutSet(long x) {
        return x >= 0L;
    }

    protected void execInit() {
        if (this.queryStartTime <= -1L) {
            this.queryStartTime = System.currentTimeMillis();
        }
    }

    private void startQueryIterator() {
        if (this.queryIterator != null) {
            Log.warn(this, "Query iterator has already been started");
        }
        this.execInit();
        if (!QueryExecDataset.isTimeoutSet(this.timeout1) && !QueryExecDataset.isTimeoutSet(this.timeout2)) {
            this.queryIterator = this.getPlan().iterator();
            return;
        }
        if (!QueryExecDataset.isTimeoutSet(this.timeout1) && QueryExecDataset.isTimeoutSet(this.timeout2)) {
            AtomicBoolean cancelSignal = new AtomicBoolean(false);
            this.context.set(ARQConstants.symCancelQuery, cancelSignal);
            TimeoutCallback callback = new TimeoutCallback(cancelSignal);
            this.expectedCallback.set(callback);
            this.timeout2Alarm = this.alarmClock.add(callback, this.timeout2);
            this.queryIterator = this.getPlan().iterator();
            if (cancelSignal.get()) {
                this.queryIterator.cancel();
            }
            return;
        }
        AtomicBoolean cancelSignal = new AtomicBoolean(false);
        this.context.set(ARQConstants.symCancelQuery, cancelSignal);
        TimeoutCallback callback = new TimeoutCallback(cancelSignal);
        this.timeout1Alarm = this.alarmClock.add(callback, this.timeout1);
        this.expectedCallback.set(callback);
        this.queryIterator = this.getPlan().iterator();
        this.queryIterator = new QueryIteratorTimer2(this.queryIterator, cancelSignal);
        if (cancelSignal.get()) {
            this.queryIterator.cancel();
        }
    }

    private Plan getPlan() {
        if (this.plan == null) {
            Binding initial = this.initialBinding != null ? this.initialBinding : BindingFactory.root();
            this.plan = this.qeFactory.create(this.query, this.dataset, initial, this.getContext());
        }
        return this.plan;
    }

    private void insertPrefixesInto(Graph graph) {
        try {
            if (this.dataset != null) {
                PrefixMap m4 = this.dataset.prefixes();
                m4.forEach((prefix, uri) -> graph.getPrefixMapping().setNsPrefix((String)prefix, (String)uri));
            }
            graph.getPrefixMapping().setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            Log.warn(this, "Exception in insertPrefixes: " + ex.getMessage(), ex);
        }
    }

    private void insertPrefixesInto(DatasetGraph dsg) {
        try {
            PrefixMap pmap = dsg.prefixes();
            if (this.dataset != null) {
                pmap.putAll(this.dataset.prefixes());
            }
            this.query.getPrefixMapping().getNsPrefixMap().forEach((prefix, uri) -> pmap.add((String)prefix, (String)uri));
        }
        catch (Exception ex) {
            Log.warn(this, "Exception in insertPrefixes: " + ex.getMessage(), ex);
        }
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        if (q.isJsonType()) {
            return "JSON";
        }
        return "<<unknown>>";
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public DatasetGraph getDataset() {
        return this.dataset;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public String getQueryString() {
        if (this.queryString == null) {
            this.queryString = this.query.toString();
        }
        return this.queryString;
    }

    class TimeoutCallback
    implements Runnable {
        private final AtomicBoolean cancelSignal;

        public TimeoutCallback(AtomicBoolean cancelSignal) {
            this.cancelSignal = cancelSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = QueryExecDataset.this.lockTimeout;
            synchronized (object) {
                if (QueryExecDataset.this.expectedCallback.get() == this && this.cancelSignal != null) {
                    this.cancelSignal.set(true);
                }
            }
        }
    }

    private class QueryIteratorTimer2
    extends QueryIteratorWrapper {
        private final AtomicBoolean cancelSignal;
        long yieldCount;
        boolean resetDone;

        public QueryIteratorTimer2(QueryIterator qIter, AtomicBoolean cancelSignal) {
            super(qIter);
            this.yieldCount = 0L;
            this.resetDone = false;
            this.cancelSignal = cancelSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Binding moveToNextBinding() {
            Binding b = super.moveToNextBinding();
            ++this.yieldCount;
            if (!this.resetDone) {
                Object object = QueryExecDataset.this.lockTimeout;
                synchronized (object) {
                    TimeoutCallback callback = new TimeoutCallback(this.cancelSignal);
                    QueryExecDataset.this.expectedCallback.set(callback);
                    if (this.cancelSignal.get()) {
                        throw new QueryCancelledException();
                    }
                    if (QueryExecDataset.this.timeout1Alarm != null) {
                        QueryExecDataset.this.alarmClock.cancel(QueryExecDataset.this.timeout1Alarm);
                        QueryExecDataset.this.timeout1Alarm = null;
                    }
                    if (QueryExecDataset.this.timeout2 > 0L) {
                        long t2 = QueryExecDataset.this.timeout2 - (System.currentTimeMillis() - QueryExecDataset.this.queryStartTime);
                        QueryExecDataset.this.timeout2Alarm = QueryExecDataset.this.alarmClock.add(callback, t2);
                    }
                    this.resetDone = true;
                }
            }
            return b;
        }
    }
}

