/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch;

import java.util.UUID;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class StreamPatch
implements StreamRDF {
    private int depth = 0;
    private RDFChanges changes;

    public StreamPatch(RDFChanges changes) {
        this.changes = changes;
    }

    @Override
    public void start() {
        ++this.depth;
        if (this.depth == 1) {
            this.changes.start();
            Node n = NodeFactory.createURI("uuid:" + UUID.randomUUID().toString());
            this.changes.header("id", n);
            this.changes.txnBegin();
        }
    }

    @Override
    public void finish() {
        if (this.depth == 1) {
            this.changes.txnCommit();
            this.changes.finish();
        }
        --this.depth;
    }

    @Override
    public void triple(Triple triple) {
        this.changes.add(null, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    public void quad(Quad quad) {
        this.changes.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri2) {
        this.changes.addPrefix(null, prefix, iri2);
    }
}

