/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.FmtUtils;

public class TextQueryFuncs {
    public static String subjectToString(Node s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("Subject node can not be null");
        }
        if (!s2.isURI() && !s2.isBlank()) {
            throw new TextIndexException("Found a subject that is not a URI nor a blank node: " + s2);
        }
        return TextQueryFuncs.nodeToString(s2);
    }

    public static String graphNodeToString(Node g2) {
        if (g2 == null) {
            return null;
        }
        if (!g2.isURI() && !g2.isBlank()) {
            throw new TextIndexException("Found a graph label that is not a URI nor a blank node: " + g2);
        }
        return TextQueryFuncs.nodeToString(g2);
    }

    private static String nodeToString(Node n) {
        return n.isURI() ? n.getURI() : "_:" + n.getBlankNodeLabel();
    }

    public static Node stringToNode(String v) {
        if (v.startsWith("_:")) {
            v = v.substring("_:".length());
            return NodeFactory.createBlankNode(v);
        }
        return NodeFactory.createURI(v);
    }

    public static Entity entityFromQuad(EntityDefinition defn, Quad quad) {
        return TextQueryFuncs.entityFromQuad(defn, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public static Entity entityFromQuad(EntityDefinition defn, Node g2, Node s2, Node p, Node o) {
        String field = defn.getField(p);
        if (field == null) {
            return null;
        }
        if (!o.isLiteral()) {
            Log.warn(TextQuery.class, "Not a literal value for mapped field-predicate: " + field + " :: " + FmtUtils.stringForString(field));
            return null;
        }
        String x = TextQueryFuncs.subjectToString(s2);
        String graphText = TextQueryFuncs.graphNodeToString(g2);
        String language = o.getLiteral().language();
        RDFDatatype datatype = o.getLiteral().getDatatype();
        Entity entity = new Entity(x, graphText, language, datatype);
        entity.put(field, o.getLiteralLexicalForm());
        return entity;
    }
}

