/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.exec.QueryExecDataset;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.QueryExecutionCompat;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionFactory {
    protected QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query2) {
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.make(query2);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset, null, null);
    }

    public static QueryExecution create(Query query2, DatasetGraph datasetGraph) {
        Objects.requireNonNull(query2, "Query is null");
        Objects.requireNonNull(datasetGraph, "DatasetGraph is null");
        return QueryExecutionFactory.make(query2, null, datasetGraph, null);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset, null, null);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, null, null);
    }

    public static QueryExecution create(Query query2, Model model) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.make(query2, model);
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    @Deprecated
    public static QueryExecution create(Query query2, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2, null, initialBinding);
        return qe;
    }

    @Deprecated
    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), initialBinding);
    }

    @Deprecated
    public static QueryExecution create(Query query2, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(query2, DatasetFactory.wrap(model), initialBinding);
    }

    public static QueryExecution create(String queryStr, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model, initialBinding);
    }

    @Deprecated
    public static QueryExecution create(String queryStr, Syntax syntax, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), model, initialBinding);
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.make(query2, dataset, initialBinding);
    }

    @Deprecated
    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    @Deprecated
    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset, QuerySolution initialBinding) {
        QueryExecution.create();
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, initialBinding);
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, Query query2) {
        return (QueryExecutionHTTP)((QueryExecutionHTTPBuilder)QueryExecution.service(serviceURL).query(query2)).build();
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, String query2) {
        return (QueryExecutionHTTP)((QueryExecutionHTTPBuilder)QueryExecution.service(serviceURL).query(query2)).build();
    }

    @Deprecated
    public static QueryExecution sparqlService(String serviceURL, String query2, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(serviceURL, query2, List.of(defaultGraph), null);
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, Query query2, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(serviceURL, query2.toString(), defaultGraphURIs, namedGraphURIs);
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, String query2, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        QueryExecutionHTTPBuilder builder = QueryExecutionFactory.createExecutionHTTP(serviceURL, query2);
        if (defaultGraphURIs != null) {
            defaultGraphURIs.forEach(builder::addDefaultGraphURI);
        }
        if (namedGraphURIs != null) {
            namedGraphURIs.forEach(builder::addNamedGraphURI);
        }
        return (QueryExecutionHTTP)builder.build();
    }

    @Deprecated
    public static QueryExecutionHTTP sparqlService(String serviceURL, Query query2, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(serviceURL, query2.toString(), List.of(defaultGraph), null);
    }

    @Deprecated
    public static QueryExecutionHTTPBuilder createServiceRequest(String service, Query query2) {
        return QueryExecutionFactory.createExecutionHTTP(service, query2.toString());
    }

    private static QueryExecutionHTTPBuilder createExecutionHTTP(String serviceURL, String queryStr) {
        return (QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.create().endpoint(serviceURL)).queryString(queryStr);
    }

    public static Plan createPlan(Query query2, DatasetGraph dataset, Binding input, Context context2) {
        return QueryExecutionFactory.makePlan(query2, dataset, input, context2);
    }

    public static Plan createPlan(Query query2, DatasetGraph dataset, Binding input) {
        return QueryExecutionFactory.makePlan(query2, dataset, input, null);
    }

    private static Query toQuery(Element pattern) {
        Query query2 = QueryFactory.make();
        query2.setQueryPattern(pattern);
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        return query2;
    }

    private static Plan makePlan(Query query2, DatasetGraph dataset, Binding input, Context context2) {
        QueryEngineFactory f;
        if (context2 == null) {
            context2 = ARQ.getContext().copy();
        }
        if (input == null) {
            input = BindingRoot.create();
        }
        if ((f = QueryEngineRegistry.findFactory(query2, dataset, context2)) == null) {
            return null;
        }
        return f.create(query2, dataset, input, context2);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    protected static QueryExecution make(Query query2) {
        return QueryExecution.create().query(query2).build();
    }

    protected static QueryExecution make(Query query2, Model model) {
        Graph graph = model.getGraph();
        DatasetGraph dataset = DatasetGraphFactory.wrap(graph);
        Graph g2 = QueryExecutionFactory.unwrap(graph);
        if (g2 instanceof GraphView) {
            GraphView gv = (GraphView)g2;
            dataset.getContext().putAll(gv.getDataset().getContext());
        }
        return QueryExecutionFactory.make(query2, null, dataset, null);
    }

    private static Graph unwrap(Graph graph) {
        while (true) {
            if (graph instanceof GraphWrapper) {
                graph = ((GraphWrapper)graph).get();
                continue;
            }
            if (!(graph instanceof WrappedGraph)) break;
            graph = ((WrappedGraph)graph).getWrapped();
        }
        return graph;
    }

    private static QueryExecution make(Query query2, Dataset dataset, QuerySolution initialBinding) {
        Binding binding = null;
        if (initialBinding != null) {
            binding = BindingLib.toBinding(initialBinding);
        }
        return QueryExecutionFactory.make(query2, dataset, null, binding);
    }

    private static QueryExecution make(Query query2, Dataset dataset, DatasetGraph datasetGraph, Binding initialBinding) {
        QueryExecDatasetBuilder builder = QueryExecDataset.newBuilder().query(query2);
        if (initialBinding != null) {
            builder.initialBinding(initialBinding);
        }
        if (dataset == null && datasetGraph == null) {
            return QueryExecutionCompat.compatibility(builder, null, query2, builder.getQueryString());
        }
        if (dataset == null) {
            builder.dataset(datasetGraph);
            dataset = DatasetFactory.wrap(datasetGraph);
        } else {
            builder.dataset(dataset.asDatasetGraph());
        }
        return QueryExecutionCompat.compatibility(builder, dataset, query2, builder.getQueryString());
    }

    private static void checkArg(Model model) {
        Objects.requireNonNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        Objects.requireNonNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query2) {
        Objects.requireNonNull(query2, "Query is null");
    }
}

