/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.IntersectionClass;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.AbstractProfile;
import org.apache.jena.ontology.impl.BooleanClassDescriptionImpl;
import org.apache.jena.rdf.model.Property;

public class IntersectionClassImpl
extends BooleanClassDescriptionImpl
implements IntersectionClass {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new IntersectionClassImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to IntersectionClass");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, OntClass.class) && AbstractProfile.containsSome(eg, node, profile.INTERSECTION_OF());
        }
    };

    public IntersectionClassImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public Property operator() {
        return this.getProfile().INTERSECTION_OF();
    }

    @Override
    public String getOperatorName() {
        return "INTERSECTION_OF";
    }
}

