/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.Iterator;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.BooleanClassDescription;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.impl.OntClassImpl;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class BooleanClassDescriptionImpl
extends OntClassImpl
implements BooleanClassDescription {
    public BooleanClassDescriptionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setOperands(RDFList operands) {
        this.setPropertyValue(this.operator(), this.getOperatorName(), operands);
    }

    @Override
    public void addOperand(Resource cls) {
        this.addListPropertyValue(this.operator(), this.getOperatorName(), cls);
    }

    @Override
    public void addOperands(Iterator<? extends Resource> classes) {
        while (classes.hasNext()) {
            this.addOperand(classes.next());
        }
    }

    @Override
    public RDFList getOperands() {
        return this.objectAs(this.operator(), this.getOperatorName(), RDFList.class);
    }

    @Override
    public ExtendedIterator<? extends OntClass> listOperands() {
        return this.getOperands().iterator().mapWith(n -> n.as(OntClass.class));
    }

    @Override
    public boolean hasOperand(Resource cls) {
        return this.getOperands().contains(cls);
    }

    @Override
    public void removeOperand(Resource res) {
        this.setOperands(this.getOperands().remove(res));
    }

    @Override
    public abstract Property operator();

    protected abstract String getOperatorName();
}

