/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.Iterator;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.Profile;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.OneToManyMap;

public abstract class AbstractProfile
implements Profile {
    protected OneToManyMap<Resource, Resource> m_aliasesMap;

    @Override
    public boolean hasAliasFor(Resource res) {
        return this.aliasMap().containsKey(res);
    }

    @Override
    public Resource getAliasFor(Resource res) {
        return this.aliasMap().get(res);
    }

    @Override
    public Iterator<Resource> listAliasesFor(Resource res) {
        return this.aliasMap().getAll(res);
    }

    public static boolean containsSome(EnhGraph g2, Node n, Property p) {
        return g2.asGraph().contains(n, p.asNode(), Node.ANY);
    }

    protected abstract Resource[][] aliasTable();

    protected OneToManyMap<Resource, Resource> aliasMap() {
        if (this.m_aliasesMap == null) {
            Resource[][] aliases;
            this.m_aliasesMap = new OneToManyMap();
            for (Resource[] aliase : aliases = this.aliasTable()) {
                this.m_aliasesMap.put(aliase[0], aliase[1]);
                this.m_aliasesMap.put(aliase[1], aliase[0]);
            }
        }
        return this.m_aliasesMap;
    }
}

