/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2;

import java.util.stream.Stream;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.mem.GraphMemBase;
import org.apache.jena.mem2.store.TripleStore;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphMem2
extends GraphMemBase
implements GraphWithPerform {
    final TripleStore tripleStore;

    public GraphMem2(TripleStore tripleStore) {
        this.tripleStore = tripleStore;
    }

    @Override
    public void destroy() {
        this.tripleStore.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.tripleStore.clear();
    }

    @Override
    public void performAdd(Triple t2) {
        this.tripleStore.add(t2);
    }

    @Override
    public void performDelete(Triple t2) {
        this.tripleStore.remove(t2);
    }

    @Override
    public Stream<Triple> stream() {
        return this.tripleStore.stream();
    }

    @Override
    public Stream<Triple> stream(Node sm, Node pm, Node om) {
        return this.tripleStore.stream(Triple.createMatch(sm, pm, om));
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Triple tripleMatch) {
        return this.tripleStore.find(tripleMatch);
    }

    @Override
    public boolean graphBaseContains(Triple tripleMatch) {
        return this.tripleStore.contains(tripleMatch);
    }

    @Override
    public int graphBaseSize() {
        return this.tripleStore.countTriples();
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new Capabilities(){

                @Override
                public boolean sizeAccurate() {
                    return true;
                }

                @Override
                public boolean addAllowed() {
                    return true;
                }

                @Override
                public boolean deleteAllowed() {
                    return true;
                }

                @Override
                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }
}

