/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Dyadic;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Union
extends Dyadic
implements Graph {
    public Union(Graph L, Graph R) {
        super(L, R);
    }

    @Override
    public void performAdd(Triple t2) {
        this.L.add(t2);
    }

    @Override
    public void performDelete(Triple t2) {
        this.L.delete(t2);
        this.R.delete(t2);
    }

    @Override
    public boolean graphBaseContains(Triple t2) {
        return this.L.contains(t2) || this.R.contains(t2);
    }

    @Override
    protected ExtendedIterator<Triple> _graphBaseFind(Triple t2) {
        Set<Triple> seen = CollectionFactory.createHashedSet();
        return Union.recording(this.L.find(t2), seen).andThen(Union.rejecting(this.R.find(t2), seen));
    }
}

