/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.ArrayList;
import java.util.List;

class StringUtil {
    StringUtil() {
    }

    public static String replace(String str2, char find, char with) {
        if (str2 == null) {
            return null;
        }
        if (find == with) {
            return str2;
        }
        int c = 0;
        int idx = str2.indexOf(find, c);
        if (idx == -1) {
            return str2;
        }
        char[] chars = str2.toCharArray();
        int len = chars.length;
        for (int i = idx; i < len; ++i) {
            if (chars[i] != find) continue;
            chars[i] = with;
        }
        return String.valueOf(chars);
    }

    public static String replace(String s2, String sub, String with) {
        if (s2 == null) {
            return null;
        }
        int c = 0;
        int i = s2.indexOf(sub, c);
        if (i == -1) {
            return s2;
        }
        StringBuilder buf = new StringBuilder(s2.length() + with.length());
        do {
            buf.append(s2, c, i);
            buf.append(with);
        } while ((i = s2.indexOf(sub, c = i + sub.length())) != -1);
        if (c < s2.length()) {
            buf.append(s2.substring(c));
        }
        return buf.toString();
    }

    public static String[] csvSplit(String s2) {
        if (s2 == null) {
            return null;
        }
        return StringUtil.csvSplit(s2, 0, s2.length());
    }

    public static String[] csvSplit(String s2, int off, int len) {
        if (s2 == null) {
            return null;
        }
        if (off < 0 || len < 0 || off > s2.length()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringUtil.csvSplit(list, s2, off, len);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> csvSplit(List<String> list, String s2, int off, int len) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        CsvSplitState state = CsvSplitState.PRE_DATA;
        StringBuilder out = new StringBuilder();
        int last = -1;
        block13: while (len > 0) {
            char ch = s2.charAt(off++);
            --len;
            switch (state) {
                case PRE_DATA: {
                    if (Character.isWhitespace(ch)) continue block13;
                    if ('\"' == ch) {
                        state = CsvSplitState.QUOTE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add("");
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    continue block13;
                }
                case DATA: {
                    if (Character.isWhitespace(ch)) {
                        last = out.length();
                        out.append(ch);
                        state = CsvSplitState.WHITE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case WHITE: {
                    if (Character.isWhitespace(ch)) {
                        out.append(ch);
                        continue block13;
                    }
                    if (',' == ch) {
                        out.setLength(last);
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    last = -1;
                    continue block13;
                }
                case QUOTE: {
                    if ('\\' == ch) {
                        state = CsvSplitState.SLOSH;
                        continue block13;
                    }
                    if ('\"' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.POST_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case SLOSH: {
                    out.append(ch);
                    state = CsvSplitState.QUOTE;
                    continue block13;
                }
                case POST_DATA: {
                    if (',' != ch) continue block13;
                    state = CsvSplitState.PRE_DATA;
                    continue block13;
                }
            }
            throw new IllegalStateException(state.toString());
        }
        switch (state) {
            case PRE_DATA: 
            case POST_DATA: {
                break;
            }
            case DATA: 
            case QUOTE: 
            case SLOSH: {
                list.add(out.toString());
                break;
            }
            case WHITE: {
                out.setLength(last);
                list.add(out.toString());
                break;
            }
            default: {
                throw new IllegalStateException(state.toString());
            }
        }
        return list;
    }

    static enum CsvSplitState {
        PRE_DATA,
        QUOTE,
        SLOSH,
        DATA,
        WHITE,
        POST_DATA;

    }
}

