/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.auth.AuthPolicyList;
import org.apache.jena.fuseki.build.BuildLib;
import org.apache.jena.fuseki.build.DatasetDescriptionMap;
import org.apache.jena.fuseki.build.FusekiExt;
import org.apache.jena.fuseki.build.FusekiPrefixes;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.DataServiceStatus;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;

public class FusekiConfig {
    private static Logger log = Fuseki.configLog;
    private static Map<String, Operation> stdRead = Map.of("sparql", Operation.Query, "query", Operation.Query, "data", Operation.GSP_R, "get", Operation.GSP_R);
    private static Map<String, Operation> stdWrite = Map.of("sparql", Operation.Query, "query", Operation.Query, "update", Operation.Update, "data", Operation.GSP_RW, "get", Operation.GSP_R, "patch", Operation.Patch);
    private static Set<Operation> stdDatasetRead = Set.of(Operation.Query, Operation.GSP_R);
    private static Set<Operation> stdDatasetWrite = Set.of(Operation.Query, Operation.Update, Operation.GSP_RW, Operation.Patch);

    public static DataService.Builder populateStdServices(DataService.Builder dataServiceBuilder, boolean allowUpdate) {
        HashSet endpoints = new HashSet();
        if (allowUpdate) {
            stdWrite.forEach((name, op) -> FusekiConfig.accEndpoint(endpoints, op, name));
            stdDatasetWrite.forEach(op -> FusekiConfig.accEndpoint(endpoints, op));
            if (FusekiExt.extraOperationServicesWrite != null) {
                FusekiExt.extraOperationServicesWrite.forEach((name, op) -> FusekiConfig.accEndpoint(endpoints, op, name));
            }
        } else {
            stdRead.forEach((name, op) -> FusekiConfig.accEndpoint(endpoints, op, name));
            stdDatasetRead.forEach(op -> FusekiConfig.accEndpoint(endpoints, op));
            if (FusekiExt.extraOperationServicesRead != null) {
                FusekiExt.extraOperationServicesRead.forEach((name, op) -> FusekiConfig.accEndpoint(endpoints, op, name));
            }
        }
        endpoints.forEach(dataServiceBuilder::addEndpoint);
        return dataServiceBuilder;
    }

    public static void addDataService(DataAccessPointRegistry dataAccessPoints, String name, DataService dataService) {
        if (dataAccessPoints.isRegistered(name = DataAccessPoint.canonical(name))) {
            throw new FusekiConfigException("Data service name already registered: " + name);
        }
        DataAccessPoint dap = new DataAccessPoint(name, dataService);
        dataAccessPoints.register(dap);
    }

    public static void addDataset(DataAccessPointRegistry dataAccessPoints, String name, DatasetGraph dsg, boolean withUpdate) {
        if (dataAccessPoints.isRegistered(name = DataAccessPoint.canonical(name))) {
            throw new FusekiConfigException("Data service name already registered: " + name);
        }
        DataService dataService = FusekiConfig.buildDataServiceStd(dsg, withUpdate);
        DataAccessPoint dap = new DataAccessPoint(name, dataService);
        dataAccessPoints.register(dap);
    }

    public static DataService buildDataServiceStd(DatasetGraph dsg, boolean withUpdate) {
        return DataService.newBuilder(dsg).withStdServices(withUpdate).build();
    }

    public static void removeDataset(DataAccessPointRegistry dataAccessPoints, String name) {
        name = DataAccessPoint.canonical(name);
        dataAccessPoints.remove(name);
    }

    public static AuthPolicy allowedUsers(Resource resource) {
        if (resource == null) {
            return null;
        }
        Collection<RDFNode> allowedUsers = BuildLib.getAll(resource, "fu:" + FusekiVocab.pAllowedUsers.getLocalName());
        if (allowedUsers == null) {
            return null;
        }
        List bad = allowedUsers.stream().map(FrontsNode::asNode).filter(rn -> !Util.isSimpleString(rn)).map(rn -> rn.toString()).collect(Collectors.toList());
        if (!bad.isEmpty()) {
            throw new FusekiConfigException(String.format("User names should be a simple string: bad = %s", bad));
        }
        Collection userNames = allowedUsers.stream().map(FrontsNode::asNode).map(Node::getLiteralLexicalForm).collect(Collectors.toList());
        return Auth.policyAllowSpecific(userNames);
    }

    public static List<DataAccessPoint> processServerConfiguration(Model configuration, Context context2) {
        Resource server = FusekiConfig.findServer(configuration);
        if (server != null) {
            FusekiConfig.mergeContext(server, context2);
            FusekiConfig.processLoadClass(server);
        }
        return FusekiConfig.servicesAndDatasets$(server, configuration);
    }

    public static Resource findServer(Model model) {
        List<Resource> servers = GraphUtils.listResourcesByType(model, FusekiVocab.tServer);
        if (servers.size() == 0) {
            return null;
        }
        if (servers.size() > 1) {
            throw new FusekiConfigException(servers.size() + " servers found (must be exactly one in a configuration file)");
        }
        Resource server = servers.get(0);
        return server;
    }

    private static Context parseContext(Resource resource) {
        if (resource == null) {
            return null;
        }
        return AssemblerUtils.parseContext(resource);
    }

    private static void mergeContext(Resource resource, Context context2) {
        if (resource == null) {
            return;
        }
        AssemblerUtils.mergeContext(resource, context2);
    }

    public static void processLoadClass(Resource server) {
        if (server == null) {
            return;
        }
        StmtIterator sIter = server.listProperties(JA.loadClass);
        while (sIter.hasNext()) {
            Statement s2 = sIter.nextStatement();
            RDFNode rn = s2.getObject();
            String className = null;
            if (rn instanceof Resource) {
                String uri = ((Resource)rn).getURI();
                if (uri == null) {
                    log.warn("Blank node for class to load");
                    continue;
                }
                String javaScheme = "java:";
                if (!uri.startsWith(javaScheme)) {
                    log.warn("Class to load is not 'java:': " + uri);
                    continue;
                }
                className = uri.substring(javaScheme.length());
            }
            if (rn instanceof Literal) {
                className = ((Literal)rn).getLexicalForm();
            }
            FusekiConfig.loadAndInit(className);
        }
    }

    public static List<DataAccessPoint> servicesAndDatasets(Model model) {
        Resource server = FusekiConfig.findServer(model);
        return FusekiConfig.servicesAndDatasets$(server, model);
    }

    public static List<DataAccessPoint> servicesAndDatasets(Resource server) {
        Objects.requireNonNull(server);
        return FusekiConfig.servicesAndDatasets$(server, server.getModel());
    }

    private static List<DataAccessPoint> servicesAndDatasets$(Resource server, Model model) {
        DatasetDescriptionMap dsDescMap = new DatasetDescriptionMap();
        ResultSet rs = BuildLib.query("SELECT * { ?s fu:services [ list:member ?service ] }", model, "s", (RDFNode)server);
        ArrayList<DataAccessPoint> accessPoints = new ArrayList<DataAccessPoint>();
        if (!rs.hasNext()) {
            rs = BuildLib.query("SELECT ?service { ?service a fu:Service }", model);
        }
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            Resource svc = soln.getResource("service");
            DataAccessPoint acc = FusekiConfig.buildDataAccessPoint(svc, dsDescMap);
            if (acc == null) continue;
            accessPoints.add(acc);
        }
        return accessPoints;
    }

    private static void loadAndInit(String className) {
        try {
            Class<?> classObj = Class.forName(className);
            log.info("Loaded " + className);
            Method initMethod = classObj.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            log.warn("Class not found: " + className);
        }
        catch (Exception e2) {
            throw new FusekiConfigException(e2);
        }
    }

    private static Model readAssemblerFile(String filename) {
        return AssemblerUtils.readAssemblerFile(filename);
    }

    public static List<DataAccessPoint> readConfigurationDirectory(String dir) {
        Path pDir = Path.of(dir, new String[0]).normalize();
        File dirFile = pDir.toFile();
        if (!dirFile.exists()) {
            log.warn("Not found: directory for assembler files for services: '" + dir + "'");
            return Collections.emptyList();
        }
        if (!dirFile.isDirectory()) {
            log.warn("Not a directory: '" + dir + "'");
            return Collections.emptyList();
        }
        DirectoryStream.Filter<Path> filter = entry -> {
            File f = entry.toFile();
            Lang lang = RDFLanguages.filenameToLang(f.getName());
            return !f.isHidden() && f.isFile() && lang != null && RDFParserRegistry.isRegistered(lang);
        };
        ArrayList<DataAccessPoint> dataServiceRef = new ArrayList<DataAccessPoint>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pDir, filter);){
            for (Path p : stream) {
                DatasetDescriptionMap dsDescMap = new DatasetDescriptionMap();
                String fn = IRILib.filenameToIRI(p.toString());
                log.info("Load configuration: " + fn);
                Model m4 = FusekiConfig.readAssemblerFile(fn);
                FusekiConfig.readConfiguration(m4, dsDescMap, dataServiceRef);
            }
        }
        catch (IOException ex) {
            log.warn("IOException:" + ex.getMessage(), ex);
        }
        return dataServiceRef;
    }

    private static void readConfiguration(Model m4, DatasetDescriptionMap dsDescMap, List<DataAccessPoint> dataServiceRef) {
        List<Resource> services = GraphUtils.listResourcesByType(m4, FusekiVocab.fusekiService);
        if (services.size() == 0) {
            log.error("No services found");
            throw new FusekiConfigException();
        }
        for (Resource service : services) {
            DataAccessPoint acc = FusekiConfig.buildDataAccessPoint(service, dsDescMap);
            if (acc == null) continue;
            dataServiceRef.add(acc);
        }
    }

    public static DataAccessPoint buildDataAccessPoint(Resource svc, DatasetDescriptionMap dsDescMap) {
        RDFNode n = BuildLib.getOne(svc, FusekiVocab.pServiceName);
        try {
            if (!n.isLiteral()) {
                throw new FusekiConfigException("Not a literal for access point name: " + FmtUtils.stringForRDFNode(n));
            }
            Literal object = n.asLiteral();
            if (object.getDatatype() != null && !object.getDatatype().equals(XSDDatatype.XSDstring)) {
                Fuseki.configLog.error(String.format("Service name '%s' is not a string", FmtUtils.stringForRDFNode(object)));
            }
            String name = object.getLexicalForm();
            name = DataAccessPoint.canonical(name);
            AuthPolicy allowedUsers = FusekiConfig.allowedUsers(svc);
            DataService dataService = FusekiConfig.buildDataService(svc, dsDescMap).setAuthPolicy(allowedUsers).build();
            DataAccessPoint dataAccess = new DataAccessPoint(name, dataService);
            return dataAccess;
        }
        catch (FusekiException ex) {
            Fuseki.configLog.error("Skipping: Failed to build service for " + FmtUtils.stringForRDFNode(n));
            Fuseki.configLog.error("    " + ex.getMessage());
            return null;
        }
    }

    private static DataService.Builder buildDataService(Resource fusekiService, DatasetDescriptionMap dsDescMap) {
        Resource datasetDesc = (Resource)BuildLib.getOne(fusekiService, FusekiVocab.pDataset);
        Dataset ds = FusekiConfig.getDataset(datasetDesc, dsDescMap);
        DataService.Builder dataService = DataService.newBuilder(ds.asDatasetGraph());
        HashSet<Endpoint> endpoints1 = new HashSet<Endpoint>();
        HashSet<Endpoint> endpoints2 = new HashSet<Endpoint>();
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.Query, fusekiService, FusekiVocab.pServiceQueryEP);
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.Update, fusekiService, FusekiVocab.pServiceUpdateEP);
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.GSP_R, fusekiService, FusekiVocab.pServiceReadGraphStoreEP);
        FusekiConfig.accEndpointOldStyle(endpoints1, Operation.GSP_RW, fusekiService, FusekiVocab.pServiceReadWriteGraphStoreEP);
        Collection<Endpoint> endpointsCompat = FusekiConfig.oldStyleCompat(dataService, endpoints1);
        endpointsCompat.forEach(dataService::addEndpoint);
        endpoints1.forEach(dataService::addEndpoint);
        FusekiConfig.accFusekiEndpoints(endpoints2, fusekiService, dsDescMap);
        endpoints2.forEach(dataService::addEndpoint);
        return dataService;
    }

    private static Collection<Endpoint> oldStyleCompat(DataService.Builder dataService, Set<Endpoint> endpoints1) {
        HashMap endpoints3 = new HashMap();
        endpoints1.forEach(ep -> {
            Operation operation = ep.getOperation();
            AuthPolicy auth = ep.getAuthPolicy();
            if (!StringUtils.isEmpty(ep.getName())) {
                if (endpoints3.containsKey(operation)) {
                    Endpoint ep1 = (Endpoint)endpoints3.get(operation);
                    auth = AuthPolicyList.merge(ep1.getAuthPolicy(), auth);
                    Endpoint ep2 = Endpoint.create(ep.getOperation(), "", auth);
                    endpoints3.put(operation, ep2);
                } else {
                    Endpoint ep2 = Endpoint.create(operation, "", auth);
                    endpoints3.put(operation, ep2);
                }
            }
        });
        endpoints1.stream().filter(ep -> StringUtils.isEmpty(ep.getName())).forEach(ep -> endpoints3.remove(ep.getOperation()));
        return endpoints3.values();
    }

    private static void accFusekiEndpoints(Set<Endpoint> endpoints, Resource fusekiService, DatasetDescriptionMap dsDescMap) {
        StmtIterator endpointsDesc = fusekiService.listProperties(FusekiVocab.pEndpoint);
        endpointsDesc.forEachRemaining(ep -> {
            if (!ep.getObject().isResource()) {
                throw new FusekiConfigException("Literal for fuseki:endpoint: expected blank node or resource: " + FmtUtils.stringForRDFNode(fusekiService));
            }
            Endpoint endpoint = FusekiConfig.buildEndpoint(fusekiService, ep.getObject().asResource());
            endpoints.add(endpoint);
        });
    }

    private static Endpoint buildEndpoint(Resource fusekiService, Resource endpoint) {
        RDFNode opResource = BuildLib.getZeroOrOne(endpoint, FusekiVocab.pOperation);
        Operation op = null;
        if (opResource != null) {
            if (!opResource.isResource() || opResource.isAnon()) {
                throw FusekiConfig.exception("Blank node endpoint operation in service %s", BuildLib.nodeLabel(fusekiService));
            }
            Node opRef = opResource.asNode();
            op = Operation.get(opRef);
        }
        if (op == null) {
            RDFNode rImpl = BuildLib.getZeroOrOne(endpoint, FusekiVocab.pImplementation);
            if (rImpl == null) {
                throw FusekiConfig.exception("No implementation for fuseki:operation '%s' in service %s", BuildLib.nodeLabel(opResource), BuildLib.nodeLabel(fusekiService));
            }
            Pair<Operation, ActionService> x = BuildLib.loadOperationActionService(rImpl);
            Operation op2 = x.getLeft();
            ActionService proc = x.getRight();
            if (op2 == null) {
                throw FusekiConfig.exception("Failed to load implementation for fuseki:operation '%s' in service %s", BuildLib.nodeLabel(opResource), BuildLib.nodeLabel(fusekiService));
            }
            op = op2;
        }
        AuthPolicy authPolicy = FusekiConfig.allowedUsers(endpoint);
        RDFNode epNameR = BuildLib.getZeroOrOne(endpoint, FusekiVocab.pEndpointName);
        String epName = null;
        if (epNameR == null) {
            epName = Endpoint.DatasetEP.string;
        } else {
            if (!epNameR.isLiteral()) {
                throw FusekiConfig.exception("Not a literal for service name for endpoint", fusekiService, endpoint, FusekiVocab.pEndpointName);
            }
            epName = epNameR.asLiteral().getLexicalForm();
        }
        Context cxt = FusekiConfig.parseContext(endpoint);
        Endpoint ep = Endpoint.create().operation(op).endpointName(epName).authPolicy(authPolicy).context(cxt).build();
        return ep;
    }

    private static FusekiConfigException exception(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        throw new FusekiConfigException(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void accEndpointOldStyle(Collection<Endpoint> endpoints, Operation operation, Resource svc, Property property) {
        String p = "<" + property.getURI() + ">";
        ResultSet rs = BuildLib.query("SELECT * { ?svc " + p + " ?ep}", svc.getModel(), "svc", (RDFNode)svc);
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            AuthPolicy authPolicy = null;
            RDFNode ep = soln.get("ep");
            String endpointName = null;
            if (ep.isLiteral()) {
                endpointName = soln.getLiteral("ep").getLexicalForm();
            } else {
                if (!ep.isResource()) throw new FusekiConfigException("Unrecognized: " + ep);
                Resource r = (Resource)ep;
                try {
                    Statement stmt = r.getProperty(FusekiVocab.pEndpointName);
                    if (stmt == null) {
                        throw new FusekiConfigException("Expected property <" + FusekiVocab.pEndpointName + "> with <" + property.getURI() + "> for <" + svc + ">");
                    }
                    endpointName = stmt.getString();
                    List<RDFNode> x = GraphUtils.multiValue(r, FusekiVocab.pAllowedUsers);
                    if (x.size() > 1) {
                        throw new FusekiConfigException("Multiple fuseki:" + FusekiVocab.pAllowedUsers.getLocalName() + " for " + r);
                    }
                    if (!x.isEmpty()) {
                        authPolicy = FusekiConfig.allowedUsers(r);
                    }
                }
                catch (ClassCastException | JenaException ex) {
                    throw new FusekiConfigException("Failed to parse endpoint: " + r);
                }
            }
            if (StringUtils.isEmpty(endpointName)) {
                endpointName = null;
            }
            Endpoint endpoint = Endpoint.create(operation, endpointName, authPolicy);
            endpoints.add(endpoint);
        }
    }

    private static void accEndpoint(Collection<Endpoint> endpoints, Operation operation) {
        FusekiConfig.accEndpoint(endpoints, operation, null);
    }

    private static void accEndpoint(Collection<Endpoint> endpoints, Operation operation, String endpointName) {
        FusekiConfig.accEndpoint(endpoints, operation, endpointName, null);
    }

    private static void accEndpoint(Collection<Endpoint> endpoints, Operation operation, String endpointName, AuthPolicy authPolicy) {
        if (StringUtils.isEmpty(endpointName)) {
            endpointName = null;
        }
        Endpoint endpoint = Endpoint.create(operation, endpointName, authPolicy);
        endpoints.add(endpoint);
    }

    public static Dataset getDataset(Resource datasetDesc, DatasetDescriptionMap dsDescMap) {
        Dataset ds = dsDescMap.get(datasetDesc);
        if (ds == null) {
            if (!datasetDesc.hasProperty(RDF.type)) {
                throw new FusekiConfigException("No rdf:type for dataset " + BuildLib.nodeLabel(datasetDesc));
            }
            ds = (Dataset)Assembler.general.open(datasetDesc);
        }
        dsDescMap.register(datasetDesc, ds);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DataAccessPoint> readSystemDatabase(Dataset ds) {
        DatasetDescriptionMap dsDescMap = new DatasetDescriptionMap();
        String qs = StrUtils.strjoinNL(FusekiPrefixes.PREFIXES, "SELECT * {", "  GRAPH ?g {", "     ?s fu:name ?name;", "        fu:status ?status .", "  }", "}");
        ArrayList<DataAccessPoint> refs = new ArrayList<DataAccessPoint>();
        ds.begin(ReadWrite.WRITE);
        try {
            ResultSet rs = BuildLib.query(qs, ds);
            while (rs.hasNext()) {
                QuerySolution row = rs.next();
                Resource s2 = row.getResource("s");
                Resource g2 = row.getResource("g");
                Resource rStatus = row.getResource("status");
                DataServiceStatus status = DataServiceStatus.status(rStatus);
                Model m4 = ds.getNamedModel(g2.getURI());
                Resource svc = m4.wrapAsResource(s2.asNode());
                DataAccessPoint ref = FusekiConfig.buildDataAccessPoint(svc, dsDescMap);
                if (ref == null) continue;
                refs.add(ref);
            }
            ds.commit();
            ArrayList<DataAccessPoint> arrayList = refs;
            return arrayList;
        }
        catch (Throwable th) {
            th.printStackTrace();
            ArrayList<DataAccessPoint> arrayList = refs;
            return arrayList;
        }
        finally {
            ds.end();
        }
    }

    static {
        Fuseki.init();
    }
}

