/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TEndpointTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class THttpClient
extends TEndpointTransport {
    private final URL url_;
    private final ByteArrayOutputStream requestBuffer_ = new ByteArrayOutputStream();
    private InputStream inputStream_ = null;
    private int connectTimeout_ = 0;
    private int readTimeout_ = 0;
    private Map<String, String> customHeaders_ = null;
    private final HttpHost host;
    private final HttpClient client;
    private static final Map<String, String> DEFAULT_HEADERS = Collections.unmodifiableMap(THttpClient.getDefaultHeaders());

    public THttpClient(TConfiguration config, String url) throws TTransportException {
        super(config);
        try {
            this.url_ = new URL(url);
            this.client = null;
            this.host = null;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public THttpClient(String url) throws TTransportException {
        super(new TConfiguration());
        try {
            this.url_ = new URL(url);
            this.client = null;
            this.host = null;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public THttpClient(TConfiguration config, String url, HttpClient client) throws TTransportException {
        super(config);
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public THttpClient(String url, HttpClient client) throws TTransportException {
        super(new TConfiguration());
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout_ = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout_ = timeout;
    }

    public void setCustomHeaders(Map<String, String> headers) {
        this.customHeaders_ = new HashMap<String, String>(headers);
    }

    public void setCustomHeader(String key, String value) {
        if (this.customHeaders_ == null) {
            this.customHeaders_ = new HashMap<String, String>();
        }
        this.customHeaders_.put(key, value);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (null != this.inputStream_) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        this.checkReadBytesAvailable(len);
        try {
            int ret = this.inputStream_.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            this.countConsumedMessageBytes(ret);
            return ret;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.requestBuffer_.write(buf, off, len);
    }

    private RequestConfig getRequestConfig() {
        RequestConfig requestConfig = RequestConfig.DEFAULT;
        if (this.connectTimeout_ > 0) {
            requestConfig = RequestConfig.copy(requestConfig).setConnectionRequestTimeout(this.connectTimeout_).build();
        }
        if (this.readTimeout_ > 0) {
            requestConfig = RequestConfig.copy(requestConfig).setSocketTimeout(this.readTimeout_).build();
        }
        return requestConfig;
    }

    private static Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-thrift");
        headers.put("Accept", "application/x-thrift");
        headers.put("User-Agent", "Java/THttpClient/HC");
        return headers;
    }

    private static void consume(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }

    private void flushUsingHttpClient() throws TTransportException {
        if (null == this.client) {
            throw new TTransportException("Null HttpClient, aborting.");
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        HttpPost post = new HttpPost(this.url_.getFile());
        try {
            post.setConfig(this.getRequestConfig());
            DEFAULT_HEADERS.forEach(post::addHeader);
            if (null != this.customHeaders_) {
                this.customHeaders_.forEach(post::addHeader);
            }
            post.setEntity(new ByteArrayEntity(data));
            HttpResponse response = this.client.execute(this.host, post);
            this.handleResponse(response);
        }
        catch (IOException ioe) {
            post.abort();
            throw new TTransportException(ioe);
        }
        finally {
            this.resetConsumedMessageSize(-1L);
            post.releaseConnection();
        }
    }

    private void handleResponse(HttpResponse response) throws TTransportException {
        try (InputStream is = response.getEntity().getContent();){
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                throw new TTransportException("HTTP Response code: " + responseCode);
            }
            byte[] readByteArray = THttpClient.readIntoByteArray(is);
            try {
                THttpClient.consume(response.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = new ByteArrayInputStream(readByteArray);
        }
        catch (IOException ioe) {
            throw new TTransportException(ioe);
        }
    }

    private static byte[] readIntoByteArray(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        do {
            if ((len = is.read(buf)) <= 0) continue;
            baos.write(buf, 0, len);
        } while (-1 != len);
        return baos.toByteArray();
    }

    @Override
    public void flush() throws TTransportException {
        if (null != this.client) {
            this.flushUsingHttpClient();
            return;
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url_.openConnection();
            if (this.connectTimeout_ > 0) {
                connection.setConnectTimeout(this.connectTimeout_);
            }
            if (this.readTimeout_ > 0) {
                connection.setReadTimeout(this.readTimeout_);
            }
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-thrift");
            connection.setRequestProperty("Accept", "application/x-thrift");
            connection.setRequestProperty("User-Agent", "Java/THttpClient");
            if (this.customHeaders_ != null) {
                for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            connection.setDoOutput(true);
            connection.connect();
            connection.getOutputStream().write(data);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new TTransportException("HTTP Response code: " + responseCode);
            }
            this.inputStream_ = connection.getInputStream();
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
        finally {
            this.resetConsumedMessageSize(-1L);
        }
    }

    public static class Factory
    extends TTransportFactory {
        private final String url;
        private final HttpClient client;

        public Factory(String url) {
            this.url = url;
            this.client = null;
        }

        public Factory(String url, HttpClient client) {
            this.url = url;
            this.client = client;
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            try {
                if (null != this.client) {
                    return new THttpClient(trans.getConfiguration(), this.url, this.client);
                }
                return new THttpClient(trans.getConfiguration(), this.url);
            }
            catch (TTransportException tte) {
                return null;
            }
        }
    }
}

