/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.sasl.NonblockingSaslHandler;
import org.apache.thrift.transport.sasl.TBaseSaslProcessorFactory;
import org.apache.thrift.transport.sasl.TSaslProcessorFactory;
import org.apache.thrift.transport.sasl.TSaslServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSaslNonblockingServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSaslNonblockingServer.class);
    private static final int DEFAULT_NETWORK_THREADS = 1;
    private static final int DEFAULT_AUTHENTICATION_THREADS = 1;
    private static final int DEFAULT_PROCESSING_THREADS = Runtime.getRuntime().availableProcessors();
    private final AcceptorThread acceptor;
    private final NetworkThreadPool networkThreadPool;
    private final ExecutorService authenticationExecutor;
    private final ExecutorService processingExecutor;
    private final TSaslServerFactory saslServerFactory;
    private final TSaslProcessorFactory saslProcessorFactory;

    public TSaslNonblockingServer(Args args) throws IOException {
        super(args);
        this.acceptor = new AcceptorThread((TNonblockingServerSocket)this.serverTransport_);
        this.networkThreadPool = new NetworkThreadPool(args.networkThreads);
        this.authenticationExecutor = Executors.newFixedThreadPool(args.saslThreads);
        this.processingExecutor = Executors.newFixedThreadPool(args.processingThreads);
        this.saslServerFactory = args.saslServerFactory;
        this.saslProcessorFactory = args.saslProcessorFactory;
    }

    @Override
    public void serve() {
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.networkThreadPool.start();
        this.acceptor.start();
        this.setServing(true);
    }

    @Override
    public void stop() {
        if (!this.stopped_) {
            this.setServing(false);
            this.stopped_ = true;
            this.acceptor.wakeup();
            this.networkThreadPool.wakeupAll();
            this.authenticationExecutor.shutdownNow();
            this.processingExecutor.shutdownNow();
        }
    }

    public void shutdown() throws InterruptedException {
        this.stop();
        this.acceptor.join();
        for (NetworkThread networkThread : this.networkThreadPool.networkThreads) {
            networkThread.join();
        }
        while (!this.authenticationExecutor.isTerminated()) {
            this.authenticationExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        while (!this.processingExecutor.isTerminated()) {
            this.processingExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    private class AcceptorThread
    extends Thread {
        private final TNonblockingServerTransport serverTransport;
        private final Selector acceptSelector;

        private AcceptorThread(TNonblockingServerSocket serverTransport) throws IOException {
            super("acceptor-thread");
            this.serverTransport = serverTransport;
            this.acceptSelector = Selector.open();
            serverTransport.registerSelector(this.acceptSelector);
        }

        @Override
        public void run() {
            try {
                this.serverTransport.listen();
                while (!TSaslNonblockingServer.this.stopped_) {
                    this.select();
                    this.acceptNewConnection();
                }
            }
            catch (TTransportException e2) {
                LOGGER.error("Failed to listen on server socket, error " + e2.getType(), e2);
            }
            catch (Throwable e3) {
                LOGGER.error("Unexpected error in acceptor thread.", e3);
            }
            finally {
                TSaslNonblockingServer.this.stop();
                this.close();
            }
        }

        void wakeup() {
            this.acceptSelector.wakeup();
        }

        private void acceptNewConnection() {
            Iterator<SelectionKey> selectedKeyItr = this.acceptSelector.selectedKeys().iterator();
            while (!TSaslNonblockingServer.this.stopped_ && selectedKeyItr.hasNext()) {
                SelectionKey selected = selectedKeyItr.next();
                selectedKeyItr.remove();
                if (selected.isAcceptable()) {
                    try {
                        TNonblockingTransport connection;
                        while ((connection = this.serverTransport.accept()) != null) {
                            if (TSaslNonblockingServer.this.networkThreadPool.acceptNewConnection(connection)) continue;
                            LOGGER.error("Network thread does not accept: " + connection);
                            connection.close();
                        }
                        continue;
                    }
                    catch (TTransportException e2) {
                        LOGGER.warn("Failed to accept incoming connection.", e2);
                        continue;
                    }
                }
                LOGGER.error("Not acceptable selection: " + selected.channel());
            }
        }

        private void select() {
            try {
                this.acceptSelector.select();
            }
            catch (IOException e2) {
                LOGGER.error("Failed to select on the server socket.", e2);
            }
        }

        private void close() {
            LOGGER.info("Closing acceptor thread.");
            this.serverTransport.close();
            try {
                this.acceptSelector.close();
            }
            catch (IOException e2) {
                LOGGER.error("Failed to close accept selector.", e2);
            }
        }
    }

    private class NetworkThreadPool {
        private final List<NetworkThread> networkThreads;
        private int accepted = 0;

        NetworkThreadPool(int size) throws IOException {
            this.networkThreads = new ArrayList<NetworkThread>(size);
            int digits = (int)Math.log10(size) + 1;
            String threadNamePattern = "network-thread-%0" + digits + "d";
            for (int i = 0; i < size; ++i) {
                this.networkThreads.add(new NetworkThread(String.format(threadNamePattern, i)));
            }
        }

        boolean acceptNewConnection(TNonblockingTransport connection) {
            return this.networkThreads.get(this.accepted++ % this.networkThreads.size()).accept(connection);
        }

        public void start() {
            for (NetworkThread thread : this.networkThreads) {
                thread.start();
            }
        }

        void wakeupAll() {
            for (NetworkThread networkThread : this.networkThreads) {
                networkThread.wakeup();
            }
        }
    }

    public static class Args
    extends TServer.AbstractServerArgs<Args> {
        private int networkThreads = 1;
        private int saslThreads = 1;
        private int processingThreads = DEFAULT_PROCESSING_THREADS;
        private TSaslServerFactory saslServerFactory = new TSaslServerFactory();
        private TSaslProcessorFactory saslProcessorFactory;

        public Args(TNonblockingServerTransport transport) {
            super(transport);
        }

        public Args networkThreads(int networkThreads) {
            this.networkThreads = networkThreads <= 0 ? 1 : networkThreads;
            return this;
        }

        public Args saslThreads(int authenticationThreads) {
            this.saslThreads = authenticationThreads <= 0 ? 1 : authenticationThreads;
            return this;
        }

        public Args processingThreads(int processingThreads) {
            this.processingThreads = processingThreads <= 0 ? DEFAULT_PROCESSING_THREADS : processingThreads;
            return this;
        }

        @Override
        public Args processor(TProcessor processor) {
            this.saslProcessorFactory = new TBaseSaslProcessorFactory(processor);
            return this;
        }

        public Args saslProcessorFactory(TSaslProcessorFactory saslProcessorFactory) {
            if (saslProcessorFactory == null) {
                throw new NullPointerException("Processor factory cannot be null");
            }
            this.saslProcessorFactory = saslProcessorFactory;
            return this;
        }

        public Args addSaslMechanism(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
            this.saslServerFactory.addSaslMechanism(mechanism, protocol, serverName, props, cbh);
            return this;
        }

        public Args saslServerFactory(TSaslServerFactory saslServerFactory) {
            if (saslServerFactory == null) {
                throw new NullPointerException("saslServerFactory cannot be null");
            }
            this.saslServerFactory = saslServerFactory;
            return this;
        }
    }

    private class NetworkThread
    extends Thread {
        private final BlockingQueue<TNonblockingTransport> incomingConnections;
        private final BlockingQueue<NonblockingSaslHandler> stateTransitions;
        private final Selector ioSelector;

        NetworkThread(String name) throws IOException {
            super(name);
            this.incomingConnections = new LinkedBlockingQueue<TNonblockingTransport>();
            this.stateTransitions = new LinkedBlockingQueue<NonblockingSaslHandler>();
            this.ioSelector = Selector.open();
        }

        @Override
        public void run() {
            try {
                while (!TSaslNonblockingServer.this.stopped_) {
                    this.handleIncomingConnections();
                    this.handleStateChanges();
                    this.select();
                    this.handleIO();
                }
            }
            catch (Throwable e2) {
                LOGGER.error("Unreoverable error in " + this.getName(), e2);
            }
            finally {
                this.close();
            }
        }

        private void handleStateChanges() {
            NonblockingSaslHandler statemachine;
            while ((statemachine = (NonblockingSaslHandler)this.stateTransitions.poll()) != null) {
                this.tryRunNextPhase(statemachine);
            }
            return;
        }

        private void select() {
            try {
                this.ioSelector.select();
            }
            catch (IOException e2) {
                LOGGER.error("Failed to select in " + this.getName(), e2);
            }
        }

        private void handleIO() {
            Iterator<SelectionKey> selectedKeyItr = this.ioSelector.selectedKeys().iterator();
            while (!TSaslNonblockingServer.this.stopped_ && selectedKeyItr.hasNext()) {
                SelectionKey selected = selectedKeyItr.next();
                selectedKeyItr.remove();
                if (!selected.isValid()) {
                    this.closeChannel(selected);
                }
                NonblockingSaslHandler saslHandler = (NonblockingSaslHandler)selected.attachment();
                if (selected.isReadable()) {
                    saslHandler.handleRead();
                } else if (selected.isWritable()) {
                    saslHandler.handleWrite();
                } else {
                    LOGGER.error("Invalid intrest op " + selected.interestOps());
                    this.closeChannel(selected);
                    continue;
                }
                if (!saslHandler.isCurrentPhaseDone()) continue;
                this.tryRunNextPhase(saslHandler);
            }
        }

        private synchronized void handleIncomingConnections() {
            TNonblockingTransport connection;
            while ((connection = (TNonblockingTransport)this.incomingConnections.poll()) != null) {
                if (!connection.isOpen()) {
                    LOGGER.warn("Incoming connection is already closed");
                    continue;
                }
                try {
                    SelectionKey selectionKey = connection.registerSelector(this.ioSelector, 1);
                    if (!selectionKey.isValid()) continue;
                    NonblockingSaslHandler saslHandler = new NonblockingSaslHandler(selectionKey, connection, TSaslNonblockingServer.this.saslServerFactory, TSaslNonblockingServer.this.saslProcessorFactory, TSaslNonblockingServer.this.inputProtocolFactory_, TSaslNonblockingServer.this.outputProtocolFactory_, TSaslNonblockingServer.this.eventHandler_);
                    selectionKey.attach(saslHandler);
                    continue;
                }
                catch (IOException e2) {
                    LOGGER.error("Failed to register connection for the selector, close it.", e2);
                    connection.close();
                    continue;
                }
                break;
            }
            return;
        }

        private synchronized void close() {
            TNonblockingTransport incomingConnection;
            LOGGER.warn("Closing " + this.getName());
            while ((incomingConnection = (TNonblockingTransport)this.incomingConnections.poll()) != null) {
                incomingConnection.close();
            }
            Set<SelectionKey> registered = this.ioSelector.keys();
            for (SelectionKey selection : registered) {
                this.closeChannel(selection);
            }
            try {
                this.ioSelector.close();
            }
            catch (IOException e2) {
                LOGGER.error("Failed to close io selector " + this.getName(), e2);
            }
        }

        private synchronized void closeChannel(SelectionKey selectionKey) {
            if (selectionKey.attachment() == null) {
                try {
                    selectionKey.channel().close();
                }
                catch (IOException e2) {
                    LOGGER.error("Failed to close channel.", e2);
                }
                finally {
                    selectionKey.cancel();
                }
            } else {
                NonblockingSaslHandler saslHandler = (NonblockingSaslHandler)selectionKey.attachment();
                saslHandler.close();
            }
        }

        private void tryRunNextPhase(NonblockingSaslHandler saslHandler) {
            NonblockingSaslHandler.Phase nextPhase = saslHandler.getNextPhase();
            saslHandler.stepToNextPhase();
            switch (nextPhase) {
                case EVALUATING_SASL_RESPONSE: {
                    TSaslNonblockingServer.this.authenticationExecutor.submit(new Computation(saslHandler));
                    break;
                }
                case PROCESSING: {
                    TSaslNonblockingServer.this.processingExecutor.submit(new Computation(saslHandler));
                    break;
                }
                case CLOSING: {
                    saslHandler.runCurrentPhase();
                    break;
                }
            }
        }

        public boolean accept(TNonblockingTransport connection) {
            if (TSaslNonblockingServer.this.stopped_) {
                return false;
            }
            if (this.incomingConnections.offer(connection)) {
                this.wakeup();
                return true;
            }
            return false;
        }

        private void wakeup() {
            this.ioSelector.wakeup();
        }

        private class Computation
        implements Runnable {
            private final NonblockingSaslHandler statemachine;

            private Computation(NonblockingSaslHandler statemachine) {
                this.statemachine = statemachine;
            }

            @Override
            public void run() {
                try {
                    while (!this.statemachine.isCurrentPhaseDone()) {
                        this.statemachine.runCurrentPhase();
                    }
                    NetworkThread.this.stateTransitions.add(this.statemachine);
                    NetworkThread.this.wakeup();
                }
                catch (Throwable e2) {
                    LOGGER.error("Damn it!", e2);
                }
            }
        }
    }
}

