/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;

public final class BlendedTermQuery
extends Query {
    public static final RewriteMethod BOOLEAN_REWRITE = new RewriteMethod(){

        @Override
        public Query rewrite(Query[] subQueries) {
            BooleanQuery.Builder merged = new BooleanQuery.Builder();
            for (Query query2 : subQueries) {
                merged.add(query2, BooleanClause.Occur.SHOULD);
            }
            return merged.build();
        }
    };
    public static final RewriteMethod DISJUNCTION_MAX_REWRITE = new DisjunctionMaxRewrite(0.01f);
    private final Term[] terms;
    private final float[] boosts;
    private final TermStates[] contexts;
    private final RewriteMethod rewriteMethod;

    private BlendedTermQuery(final Term[] terms, final float[] boosts, final TermStates[] contexts, RewriteMethod rewriteMethod) {
        assert (terms.length == boosts.length);
        assert (terms.length == contexts.length);
        this.terms = terms;
        this.boosts = boosts;
        this.contexts = contexts;
        this.rewriteMethod = rewriteMethod;
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                Term tmpTerm = terms[i];
                terms[i] = terms[j];
                terms[j] = tmpTerm;
                TermStates tmpContext = contexts[i];
                contexts[i] = contexts[j];
                contexts[j] = tmpContext;
                float tmpBoost = boosts[i];
                boosts[i] = boosts[j];
                boosts[j] = tmpBoost;
            }

            @Override
            protected int compare(int i, int j) {
                return terms[i].compareTo(terms[j]);
            }
        }.sort(0, terms.length);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((BlendedTermQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(BlendedTermQuery other) {
        return Arrays.equals(this.terms, other.terms) && Arrays.equals(this.contexts, other.contexts) && Arrays.equals(this.boosts, other.boosts) && this.rewriteMethod.equals(other.rewriteMethod);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Arrays.hashCode(this.terms);
        h = 31 * h + Arrays.hashCode(this.contexts);
        h = 31 * h + Arrays.hashCode(this.boosts);
        h = 31 * h + this.rewriteMethod.hashCode();
        return h;
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder("Blended(");
        for (int i = 0; i < this.terms.length; ++i) {
            if (i != 0) {
                builder.append(" ");
            }
            Query termQuery = new TermQuery(this.terms[i]);
            if (this.boosts[i] != 1.0f) {
                termQuery = new BoostQuery(termQuery, this.boosts[i]);
            }
            builder.append(((Query)termQuery).toString(field));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public final Query rewrite(IndexReader reader) throws IOException {
        TermStates[] contexts = ArrayUtil.copyOfSubArray(this.contexts, 0, this.contexts.length);
        for (int i = 0; i < contexts.length; ++i) {
            if (contexts[i] != null && contexts[i].wasBuiltFor(reader.getContext())) continue;
            contexts[i] = TermStates.build(reader.getContext(), this.terms[i], true);
        }
        int df = 0;
        long ttf = 0L;
        for (TermStates ctx : contexts) {
            df = Math.max(df, ctx.docFreq());
            ttf += ctx.totalTermFreq();
        }
        for (int i = 0; i < contexts.length; ++i) {
            contexts[i] = BlendedTermQuery.adjustFrequencies(reader.getContext(), contexts[i], df, ttf);
        }
        Query[] termQueries = new Query[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            termQueries[i] = new TermQuery(this.terms[i], contexts[i]);
            if (this.boosts[i] == 1.0f) continue;
            termQueries[i] = new BoostQuery(termQueries[i], this.boosts[i]);
        }
        return this.rewriteMethod.rewrite(termQueries);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        Term[] termsToVisit = (Term[])Arrays.stream(this.terms).filter(t -> visitor.acceptField(t.field())).toArray(Term[]::new);
        if (termsToVisit.length > 0) {
            QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
            v.consumeTerms(this, termsToVisit);
        }
    }

    private static TermStates adjustFrequencies(IndexReaderContext readerContext, TermStates ctx, int artificialDf, long artificialTtf) throws IOException {
        List<LeafReaderContext> leaves = readerContext.leaves();
        TermStates newCtx = new TermStates(readerContext);
        for (int i = 0; i < leaves.size(); ++i) {
            TermState termState = ctx.get(leaves.get(i));
            if (termState == null) continue;
            newCtx.register(termState, i);
        }
        newCtx.accumulateStatistics(artificialDf, artificialTtf);
        return newCtx;
    }

    public static class DisjunctionMaxRewrite
    extends RewriteMethod {
        private final float tieBreakerMultiplier;

        public DisjunctionMaxRewrite(float tieBreakerMultiplier) {
            this.tieBreakerMultiplier = tieBreakerMultiplier;
        }

        @Override
        public Query rewrite(Query[] subQueries) {
            return new DisjunctionMaxQuery(Arrays.asList(subQueries), this.tieBreakerMultiplier);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DisjunctionMaxRewrite that = (DisjunctionMaxRewrite)obj;
            return this.tieBreakerMultiplier == that.tieBreakerMultiplier;
        }

        public int hashCode() {
            return 31 * this.getClass().hashCode() + Float.floatToIntBits(this.tieBreakerMultiplier);
        }
    }

    public static abstract class RewriteMethod {
        protected RewriteMethod() {
        }

        public abstract Query rewrite(Query[] var1);
    }

    public static class Builder {
        private int numTerms = 0;
        private Term[] terms = new Term[0];
        private float[] boosts = new float[0];
        private TermStates[] contexts = new TermStates[0];
        private RewriteMethod rewriteMethod = DISJUNCTION_MAX_REWRITE;

        public Builder setRewriteMethod(RewriteMethod rewiteMethod) {
            this.rewriteMethod = rewiteMethod;
            return this;
        }

        public Builder add(Term term) {
            return this.add(term, 1.0f);
        }

        public Builder add(Term term, float boost) {
            return this.add(term, boost, null);
        }

        public Builder add(Term term, float boost, TermStates context2) {
            if (this.numTerms >= IndexSearcher.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses();
            }
            this.terms = ArrayUtil.grow(this.terms, this.numTerms + 1);
            this.boosts = ArrayUtil.grow(this.boosts, this.numTerms + 1);
            this.contexts = ArrayUtil.grow(this.contexts, this.numTerms + 1);
            this.terms[this.numTerms] = term;
            this.boosts[this.numTerms] = boost;
            this.contexts[this.numTerms] = context2;
            ++this.numTerms;
            return this;
        }

        public BlendedTermQuery build() {
            return new BlendedTermQuery(ArrayUtil.copyOfSubArray(this.terms, 0, this.numTerms), ArrayUtil.copyOfSubArray(this.boosts, 0, this.numTerms), ArrayUtil.copyOfSubArray(this.contexts, 0, this.numTerms), this.rewriteMethod);
        }
    }
}

