/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.util.SystemPropertiesPropertySource;

public final class Strings {
    private static final ThreadLocal<StringBuilder> tempStr = ThreadLocal.withInitial(StringBuilder::new);
    public static final String EMPTY = "";
    private static final String COMMA_DELIMITED_RE = "\\s*,\\s*";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String LINE_SEPARATOR = SystemPropertiesPropertySource.getSystemProperty("line.separator", "\n");

    public static String dquote(String str2) {
        return '\"' + str2 + '\"';
    }

    public static boolean isBlank(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !Strings.isBlank(s);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Strings.isEmpty(cs);
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String[] splitList(String string) {
        return string != null ? string.split(COMMA_DELIMITED_RE) : new String[]{};
    }

    public static String left(String str2, int len) {
        if (str2 == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str2.length() <= len) {
            return str2;
        }
        return str2.substring(0, len);
    }

    public static String quote(String str2) {
        return '\'' + str2 + '\'';
    }

    public static String trimToNull(String str2) {
        String ts = str2 == null ? null : str2.trim();
        return Strings.isEmpty(ts) ? null : ts;
    }

    private Strings() {
    }

    public static String toRootLowerCase(String str2) {
        return str2.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String str2) {
        return str2.toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(String str1, String str2) {
        if (Strings.isEmpty(str1)) {
            return str2;
        }
        if (Strings.isEmpty(str2)) {
            return str1;
        }
        StringBuilder sb = tempStr.get();
        try {
            String string = sb.append(str1).append(str2).toString();
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String repeat(String str2, int count) {
        Objects.requireNonNull(str2, "str");
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        StringBuilder sb = tempStr.get();
        try {
            for (int index = 0; index < count; ++index) {
                sb.append(str2);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }
}

