/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.other.RDFDataException;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeConst;

public class Imports {
    private Imports() {
    }

    public static Graph loadWithImports(String url) {
        url = IRIs.resolve(url);
        Graph graph = RDFDataMgr.loadGraph(url);
        return Imports.withImportsWorker(url, graph);
    }

    public static Graph withImports(Graph graph) {
        return Imports.withImportsWorker(null, graph);
    }

    public static Graph withImports(String url, Graph graph) {
        url = IRIs.resolve(url);
        return Imports.withImportsWorker(url, graph);
    }

    private static Graph withImportsWorker(String url, Graph graph) {
        boolean hasImports = G.contains(graph, null, NodeConst.nodeOwlImports, null);
        if (!hasImports) {
            return graph;
        }
        Graph acc = GraphFactory.createDefaultGraph();
        GraphUtil.addInto(acc, graph);
        HashSet<String> visited = new HashSet<String>();
        if (url != null) {
            visited.add(url);
        }
        Imports.processImports(visited, graph, acc);
        return acc;
    }

    private static void processImports(Set<String> visited, Graph graph, Graph acc) {
        List<Node> imports = Imports.imports(graph);
        for (Node imported : imports) {
            String uri;
            if (!imported.isURI() || visited.contains(uri = imported.getURI())) continue;
            visited.add(uri);
            Graph g2 = RDFDataMgr.loadGraph(uri);
            GraphUtil.addInto(acc, g2);
            Imports.processImports(visited, g2, acc);
        }
    }

    public static List<Node> imports(Graph graph) {
        Pair<Node, List<Node>> pair = Imports.baseAndImports(graph);
        return pair.getRight();
    }

    public static Pair<Node, List<Node>> baseAndImports(Graph graph) {
        Node base = null;
        if (G.containsOne(graph, null, NodeConst.nodeRDFType, NodeConst.nodeOwlOntology)) {
            base = G.getOnePO(graph, NodeConst.nodeRDFType, NodeConst.nodeOwlOntology);
        }
        List<Node> imports = Imports.allImports(base, graph);
        return Pair.create(base, imports);
    }

    public static Node base(Graph graph) {
        try {
            return G.getZeroOrOnePO(graph, NodeConst.nodeRDFType, NodeConst.nodeOwlOntology);
        }
        catch (RDFDataException ex) {
            return null;
        }
    }

    public static List<Node> allImports(Node base, Graph graph) {
        List<Node> imports = Iter.iter(G.listSP(graph, base, NodeConst.nodeOwlImports)).filter(Node::isURI).collect(Collectors.toList());
        return imports;
    }
}

