/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class DataUploader {
    private static final MultipartConfigElement multipartConfigElement;
    private static final String jettyMultipartAttributeName;

    public static UploadDetails incomingData(HttpAction action, StreamRDF dest) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No content type");
            return null;
        }
        if (WebContent.matchContentType(WebContent.ctMultipartFormData, ct) || WebContent.matchContentType(WebContent.ctMultipartMixed, ct)) {
            return DataUploader.fileUploadMultipart(action, dest);
        }
        String base = ActionLib.wholeRequestURL(action.getRequest());
        Lang lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + ct);
            return null;
        }
        long len = action.getRequestContentLengthLong();
        StreamRDFCounting countingDest = StreamRDFLib.count(dest);
        try {
            ActionLib.parse(action, countingDest, lang, base);
            UploadDetails details = new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
            action.log.info(String.format("[%d] Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s : %s", action.id, len, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), details.detailsStr()));
            return details;
        }
        catch (RiotParseException ex) {
            action.log.info(String.format("[%d] Attempt to load: Content-Length=%d, Content-Type=%s, Charset=%s => %s", action.id, len, ct.getContentTypeStr(), ct.getCharset(), ex.getMessage()));
            ActionLib.consumeBody(action);
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UploadDetails fileUploadMultipart(HttpAction action, StreamRDF dest) {
        HttpServletRequest request = action.getRequest();
        String base = ActionLib.wholeRequestURL(request);
        StreamRDFCounting countingDest = StreamRDFLib.count(dest);
        if (jettyMultipartAttributeName != null && request.getAttribute(jettyMultipartAttributeName) == null) {
            request.setAttribute(jettyMultipartAttributeName, multipartConfigElement);
        }
        try {
            Iterator<Part> iterator = request.getParts().iterator();
            while (iterator.hasNext()) {
                String printfilename;
                Part part = iterator.next();
                InputStream input = part.getInputStream();
                String contentTypeHeader = part.getContentType();
                ContentType ct = ContentType.create(contentTypeHeader);
                Lang lang = null;
                if (!WebContent.matchContentType(WebContent.ctTextPlain, ct)) {
                    lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
                }
                if (lang == null) {
                    String name = part.getSubmittedFileName();
                    if (name == null || name.equals("")) {
                        ServletOps.errorBadRequest("No name for content - can't determine RDF syntax");
                    }
                    lang = RDFLanguages.pathnameToLang(name);
                    if (name.endsWith(".gz")) {
                        input = new GZIPInputStream(input);
                    }
                }
                if (lang == null) {
                    lang = RDFLanguages.RDFXML;
                }
                if ((printfilename = part.getSubmittedFileName()) == null || printfilename.equals("")) {
                    printfilename = "<none>";
                }
                StreamRDFCounting countingDest2 = StreamRDFLib.count(countingDest);
                try {
                    ActionLib.parse(action, countingDest2, input, lang, base);
                    UploadDetails details1 = new UploadDetails(countingDest2.count(), countingDest2.countTriples(), countingDest2.countQuads());
                    action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), details1.detailsStr()));
                }
                catch (RiotParseException ex) {
                    action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), ex.getMessage()));
                    ActionLib.consumeBody(action);
                    throw ex;
                }
            }
            return new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex.getMessage());
        }
        return new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
    }

    static {
        String x;
        multipartConfigElement = new MultipartConfigElement("");
        try {
            Class.forName("org.eclipse.jetty.server.Request");
            x = "org.eclipse.jetty.multipartConfig";
        }
        catch (ClassNotFoundException th) {
            x = null;
        }
        jettyMultipartAttributeName = x;
    }
}

