/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.RequestLog;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.ActionCategory;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.shared.OperationDeniedException;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.web.HttpSC;
import org.slf4j.Logger;

public class ActionExecLib {
    private static AtomicLong requestIdAlloc = new AtomicLong(0L);

    public static HttpAction allocHttpAction(DataAccessPoint dap, Logger log2, ActionCategory category, HttpServletRequest request, HttpServletResponse response) {
        long id = ActionExecLib.allocRequestId(request, response);
        HttpAction action = new HttpAction(id, log2, category, request, response);
        if (dap != null) {
            DataService dataService = dap.getDataService();
            action.setRequest(dap, dataService);
        }
        return action;
    }

    public static void execAction(HttpAction action, ActionProcessor processor) {
        boolean b = ActionExecLib.execAction(action, () -> processor);
        if (!b) {
            ServletOps.errorNotFound("Not found: " + action.getActionURI());
        }
    }

    public static boolean execAction(HttpAction action, Supplier<ActionProcessor> processor) {
        try {
            return ActionExecLib.execActionSub(action, processor);
        }
        catch (Throwable th) {
            FmtLog.error(action.log, th, "Internal error", new Object[0]);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean execActionSub(HttpAction action, Supplier<ActionProcessor> processor) {
        ActionExecLib.logRequest(action);
        action.setStartTime();
        ActionExecLib.initResponse(action);
        HttpServletResponse response = action.getResponse();
        ActionExecLib.startRequest(action);
        try {
            ActionProcessor proc = processor.get();
            if (proc == null) {
                ActionExecLib.finishRequest(action);
                ActionExecLib.logNoResponse(action);
                ActionExecLib.archiveHttpAction(action);
                boolean bl = false;
                return bl;
            }
            proc.process(action);
        }
        catch (QueryCancelledException ex) {
            String message = "Query timed out";
            ServletOps.responseSendError(response, 503, message);
        }
        catch (OperationDeniedException ex) {
            if (ex.getMessage() == null) {
                FmtLog.info(action.log, "[%d] OperationDeniedException", action.id);
            } else {
                FmtLog.info(action.log, "[%d] OperationDeniedException: %s", action.id, ex.getMessage());
            }
            ServletOps.responseSendError(response, 403);
        }
        catch (ActionErrorException ex) {
            if (ex.getCause() != null) {
                FmtLog.warn(action.log, (Throwable)ex, "[%d] ActionErrorException with cause", action.id);
            }
            if (ex.getMessage() != null) {
                ServletOps.responseSendError(response, ex.getRC(), ex.getMessage());
            } else {
                ServletOps.responseSendError(response, ex.getRC());
            }
        }
        catch (HttpException ex) {
            int sc = ex.getStatusCode();
            if (sc <= 0) {
                sc = 400;
            }
            if (ex.getMessage() == null) {
                ServletOps.responseSendError(response, sc);
            } else {
                ServletOps.responseSendError(response, sc, ex.getMessage());
            }
        }
        catch (QueryExceptionHTTP ex) {
            int sc = ex.getStatusCode();
            if (sc <= 0) {
                sc = 502;
            }
            if (ex.getMessage() == null) {
                ServletOps.responseSendError(response, sc);
            } else {
                ServletOps.responseSendError(response, sc, ex.getMessage());
            }
        }
        catch (RuntimeIOException ex) {
            FmtLog.warn(action.log, "[%d] Runtime IO Exception (client left?) RC = %d : %s", action.id, 500, ex.getMessage());
            ServletOps.responseSendError(response, 500, ex.getMessage());
        }
        catch (ExprException ex) {
            FmtLog.warn(action.log, "[%d] RC = %d : %s", action.id, 500, ex.getMessage());
            ServletOps.responseSendError(response, 500, ex.getMessage());
        }
        catch (Throwable ex) {
            FmtLog.warn(action.log, ex, "[%d] RC = %d : %s", action.id, 500, ex.getMessage());
            ServletOps.responseSendError(response, 500, ex.getMessage());
        }
        finally {
            action.setFinishTime();
            ActionExecLib.finishRequest(action);
        }
        ActionExecLib.logResponse(action);
        ActionExecLib.archiveHttpAction(action);
        return true;
    }

    public static long allocRequestId(HttpServletRequest request, HttpServletResponse response) {
        long id = requestIdAlloc.incrementAndGet();
        ActionExecLib.addRequestId(response, id);
        return id;
    }

    public static void addRequestId(HttpServletResponse response, long id) {
        response.setHeader(Fuseki.FusekiRequestIdHeader, Long.toString(id));
    }

    private static void startRequest(HttpAction action) {
        action.startRequest();
    }

    private static void finishRequest(HttpAction action) {
        action.finishRequest();
    }

    private static boolean logLifecycle(HttpAction action) {
        return action.verbose || action.category != ActionCategory.ADMIN;
    }

    public static void logRequest(HttpAction action) {
        Enumeration<String> en;
        String url = ActionLib.wholeRequestURL(action.getRequest());
        String method = action.getRequestMethod();
        if (ActionExecLib.logLifecycle(action)) {
            FmtLog.info(action.log, "[%d] %s %s", action.id, method, url);
        }
        if (action.verbose && (en = action.getRequestHeaderNames()) != null) {
            while (en.hasMoreElements()) {
                String h = en.nextElement();
                Enumeration<String> vals = action.getRequestHeaders(h);
                if (!vals.hasMoreElements()) {
                    FmtLog.info(action.log, "[%d]   => %s", action.id, h + ":");
                    continue;
                }
                while (vals.hasMoreElements()) {
                    FmtLog.info(action.log, "[%d]   => %-20s %s", action.id, h + ":", vals.nextElement());
                }
            }
        }
    }

    public static void logResponse(HttpAction action) {
        long time = action.getTime();
        if (action.verbose) {
            if (action.responseContentType != null) {
                FmtLog.info(action.log, "[%d]   <= %-20s %s", action.id, "Content-Type:", action.responseContentType);
            }
            if (action.responseContentLength != -1) {
                FmtLog.info(action.log, "[%d]   <= %-20s %d", action.id, "Content-Length:", action.responseContentLength);
            }
            for (Map.Entry<String, String> e2 : action.headers.entrySet()) {
                if (e2.getKey().equalsIgnoreCase("Content-Type") && action.responseContentType != null || e2.getKey().equalsIgnoreCase("Content-Length") && action.responseContentLength != -1) continue;
                FmtLog.info(action.log, "[%d]   <= %-20s %s", action.id, e2.getKey() + ":", e2.getValue());
            }
        }
        String timeStr = ActionExecLib.fmtMillis(time);
        if (ActionExecLib.logLifecycle(action)) {
            if (action.message == null) {
                FmtLog.info(action.log, "[%d] %d %s (%s)", action.id, action.statusCode, HttpSC.getMessage(action.statusCode), timeStr);
            } else {
                FmtLog.info(action.log, "[%d] %d %s (%s)", action.id, action.statusCode, action.message, timeStr);
            }
        }
        if (action.category == ActionCategory.ACTION && Fuseki.requestLog != null && Fuseki.requestLog.isInfoEnabled()) {
            String s = RequestLog.combinedNCSA(action);
            Fuseki.requestLog.info(s);
        }
    }

    public static void logNoResponse(HttpAction action) {
        FmtLog.info(action.log, "[%d] No Fuseki dispatch %s", action.id, action.getActionURI());
    }

    public static void initResponse(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        String method = action.getRequestMethod();
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            ServletBase.setVaryHeader(action.getResponse());
        }
    }

    private static String fmtMillis(long time) {
        if (time < 1000L) {
            return String.format("%,d ms", time);
        }
        return String.format("%,.3f s", (double)time / 1000.0);
    }

    private static void archiveHttpAction(HttpAction action) {
        action.minimize();
    }

    public static void incCounter(Counters counters, CounterName name) {
        if (counters == null) {
            return;
        }
        ActionExecLib.incCounter(counters.getCounters(), name);
    }

    public static void decCounter(Counters counters, CounterName name) {
        if (counters == null) {
            return;
        }
        ActionExecLib.decCounter(counters.getCounters(), name);
    }

    public static void incCounter(CounterSet counters, CounterName name) {
        if (counters == null) {
            return;
        }
        try {
            if (counters.contains(name)) {
                counters.inc(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter inc", ex);
        }
    }

    public static void decCounter(CounterSet counters, CounterName name) {
        if (counters == null) {
            return;
        }
        try {
            if (counters.contains(name)) {
                counters.dec(name);
            }
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("Exception on counter dec", ex);
        }
    }
}

