/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Objects;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.server.ValidString;
import org.apache.jena.fuseki.server.Validators;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.sparql.util.Context;

public class Endpoint
implements Counters {
    public static final ValidString DatasetEP = Validators.endpointName("");
    private final Operation operation;
    private ActionProcessor processor = null;
    private final ValidString endpointName;
    private final AuthPolicy authPolicy;
    private final Context context;
    private final CounterSet counters = new CounterSet();

    public static Builder create() {
        return new Builder();
    }

    public static Endpoint create(Operation operation, String endpointName, AuthPolicy requestAuth) {
        return Endpoint.create().operation(operation).endpointName(endpointName).authPolicy(requestAuth).build();
    }

    public static Endpoint create(Operation operation, String endpointName) {
        return Endpoint.create().operation(operation).endpointName(endpointName).build();
    }

    private Endpoint(Operation operation, ValidString endpointName, AuthPolicy requestAuth, ActionProcessor processor, Context context2) {
        this.operation = Objects.requireNonNull(operation, "operation");
        this.endpointName = endpointName == null ? DatasetEP : endpointName;
        this.authPolicy = requestAuth;
        this.context = context2;
        this.processor = processor;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
    }

    @Override
    public CounterSet getCounters() {
        return this.counters;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public ActionProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(ActionProcessor proc) {
        this.processor = proc;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isUnnamed() {
        return this.endpointName == null || this.endpointName.string == null || this.endpointName.string.isEmpty();
    }

    public String getName() {
        return this.isUnnamed() ? Endpoint.DatasetEP.string : this.endpointName.string;
    }

    public AuthPolicy getAuthPolicy() {
        return this.authPolicy;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }

    public static boolean sameNameAndOperation(Endpoint ep1, Endpoint ep2) {
        return Objects.equals(ep1.getName(), ep2.getName()) && Objects.equals(ep1.getOperation(), ep2.getOperation());
    }

    public String toString() {
        return this.getName() + "[" + this.operation + "]";
    }

    public static class Builder {
        private Context context = null;
        private Operation operation = null;
        private ValidString endpointName = null;
        private AuthPolicy authPolicy = null;
        private ActionProcessor processor = null;

        private Builder() {
        }

        public Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder endpointName(String endpointName) {
            this.endpointName = Validators.endpointName(endpointName);
            return this;
        }

        public Builder context(Context context2) {
            this.context = context2;
            return this;
        }

        public Builder authPolicy(AuthPolicy authPolicy) {
            this.authPolicy = authPolicy;
            return this;
        }

        public Builder processor(ActionProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Context context() {
            return this.context;
        }

        public Operation operation() {
            return this.operation;
        }

        public String endpointName() {
            return this.endpointName.string;
        }

        public AuthPolicy authPolicy() {
            return this.authPolicy;
        }

        public ActionProcessor processor() {
            return this.processor;
        }

        public Endpoint build() {
            Objects.requireNonNull(this.operation, "Operation for Endpoint");
            return new Endpoint(this.operation, this.endpointName, this.authPolicy, this.processor, this.context);
        }
    }
}

