/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.env;

import javax.servlet.ServletContext;
import org.apache.shiro.env.DefaultEnvironment;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.web.config.ShiroFilterConfiguration;
import org.apache.shiro.web.env.MutableWebEnvironment;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;

public class DefaultWebEnvironment
extends DefaultEnvironment
implements MutableWebEnvironment {
    private static final String DEFAULT_FILTER_CHAIN_RESOLVER_NAME = "filterChainResolver";
    private static final String SHIRO_FILTER_CONFIG_NAME = "shiroFilter";
    private ServletContext servletContext;

    @Override
    public FilterChainResolver getFilterChainResolver() {
        return this.getObject(DEFAULT_FILTER_CHAIN_RESOLVER_NAME, FilterChainResolver.class);
    }

    @Override
    public void setFilterChainResolver(FilterChainResolver filterChainResolver) {
        this.setObject(DEFAULT_FILTER_CHAIN_RESOLVER_NAME, filterChainResolver);
    }

    @Override
    public SecurityManager getSecurityManager() throws IllegalStateException {
        return this.getWebSecurityManager();
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        this.assertWebSecurityManager(securityManager);
        super.setSecurityManager(securityManager);
    }

    @Override
    public WebSecurityManager getWebSecurityManager() {
        SecurityManager sm = super.getSecurityManager();
        this.assertWebSecurityManager(sm);
        return (WebSecurityManager)sm;
    }

    @Override
    public void setWebSecurityManager(WebSecurityManager wsm) {
        super.setSecurityManager(wsm);
    }

    private void assertWebSecurityManager(SecurityManager sm) {
        if (!(sm instanceof WebSecurityManager)) {
            String msg = "SecurityManager instance must be a " + WebSecurityManager.class.getName() + " instance.";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void setShiroFilterConfiguration(ShiroFilterConfiguration filterConfiguration) {
        this.setObject(SHIRO_FILTER_CONFIG_NAME, filterConfiguration);
    }

    @Override
    public ShiroFilterConfiguration getShiroFilterConfiguration() {
        ShiroFilterConfiguration config = this.getObject(SHIRO_FILTER_CONFIG_NAME, ShiroFilterConfiguration.class);
        if (config == null) {
            config = MutableWebEnvironment.super.getShiroFilterConfiguration();
            this.setShiroFilterConfiguration(config);
        }
        return config;
    }
}

