/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.lucene.store.ByteBufferGuard;
import org.apache.lucene.store.ByteBufferIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SuppressForbidden;

final class MappedByteBufferIndexInputProvider
implements MMapDirectory.MMapIndexInputProvider {
    private static final Logger LOG = Logger.getLogger(MappedByteBufferIndexInputProvider.class.getName());
    private final ByteBufferGuard.BufferCleaner cleaner;
    private final boolean unmapSupported;
    private final String unmapNotSupportedReason;

    public MappedByteBufferIndexInputProvider() {
        Object hack = MappedByteBufferIndexInputProvider.unmapHackImpl();
        if (hack instanceof ByteBufferGuard.BufferCleaner) {
            this.cleaner = (ByteBufferGuard.BufferCleaner)hack;
            this.unmapSupported = true;
            this.unmapNotSupportedReason = null;
        } else {
            this.cleaner = null;
            this.unmapSupported = false;
            this.unmapNotSupportedReason = hack.toString();
            LOG.warning(this.unmapNotSupportedReason);
        }
    }

    @Override
    public IndexInput openInput(Path path, IOContext context2, int chunkSizePower, boolean preload) throws IOException {
        if (chunkSizePower > 30) {
            throw new IllegalArgumentException("ByteBufferIndexInput cannot use a chunk size of >1 GiBytes.");
        }
        String resourceDescription = "ByteBufferIndexInput(path=\"" + path.toString() + "\")";
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);){
            long fileSize = fc.size();
            ByteBufferIndexInput byteBufferIndexInput = ByteBufferIndexInput.newInstance(resourceDescription, this.map(resourceDescription, fc, chunkSizePower, preload, fileSize), fileSize, chunkSizePower, new ByteBufferGuard(resourceDescription, this.cleaner));
            return byteBufferIndexInput;
        }
    }

    @Override
    public long getDefaultMaxChunkSize() {
        return Constants.JRE_IS_64BIT ? 0x40000000L : 0x10000000L;
    }

    @Override
    public boolean isUnmapSupported() {
        return this.unmapSupported;
    }

    @Override
    public String getUnmapNotSupportedReason() {
        return this.unmapNotSupportedReason;
    }

    final ByteBuffer[] map(String resourceDescription, FileChannel fc, int chunkSizePower, boolean preload, long length) throws IOException {
        if (length >>> chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + resourceDescription);
        }
        long chunkSize = 1L << chunkSizePower;
        int nrBuffers = (int)(length >>> chunkSizePower) + 1;
        ByteBuffer[] buffers = new ByteBuffer[nrBuffers];
        long startOffset = 0L;
        for (int bufNr = 0; bufNr < nrBuffers; ++bufNr) {
            MappedByteBuffer buffer;
            int bufSize = (int)(length > startOffset + chunkSize ? chunkSize : length - startOffset);
            try {
                buffer = fc.map(FileChannel.MapMode.READ_ONLY, startOffset, bufSize);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            catch (IOException ioe) {
                throw this.convertMapFailedIOException(ioe, resourceDescription, bufSize);
            }
            if (preload) {
                buffer.load();
            }
            buffers[bufNr] = buffer;
            startOffset += (long)bufSize;
        }
        return buffers;
    }

    private static boolean checkUnmapHackSysprop() {
        try {
            return Optional.ofNullable(System.getProperty("org.apache.lucene.store.MMapDirectory.enableUnmapHack")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        }
        catch (SecurityException ignored) {
            LOG.warning("Cannot read sysprop org.apache.lucene.store.MMapDirectory.enableUnmapHack, so buffer unmap hack will be enabled by default, if possible.");
            return true;
        }
    }

    @SuppressForbidden(reason="Needs access to sun.misc.Unsafe to enable hack")
    private static Object unmapHackImpl() {
        if (!MappedByteBufferIndexInputProvider.checkUnmapHackSysprop()) {
            return "Unmapping was disabled by system property org.apache.lucene.store.MMapDirectory.enableUnmapHack=false";
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = lookup.findClass("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return MappedByteBufferIndexInputProvider.newBufferCleaner(unmapper.bindTo(theUnsafe));
        }
        catch (SecurityException se) {
            return "Unmapping is not supported, because not all required permissions are given to the Lucene JAR file: " + se + " [Please grant at least the following permissions: RuntimePermission(\"accessClassInPackage.sun.misc\")  and ReflectPermission(\"suppressAccessChecks\")]";
        }
        catch (ReflectiveOperationException | RuntimeException e2) {
            Module module = MappedByteBufferIndexInputProvider.class.getModule();
            ModuleLayer layer = module.getLayer();
            if (layer != null) {
                if (!layer.findModule("jdk.unsupported").map(module::canRead).orElse(false).booleanValue()) {
                    return "Unmapping is not supported, because Lucene cannot read 'jdk.unsupported' module [please add 'jdk.unsupported' to modular application either by command line or its module descriptor]";
                }
            }
            return "Unmapping is not supported on this platform, because internal Java APIs are not compatible with this Lucene version: " + e2;
        }
    }

    private static ByteBufferGuard.BufferCleaner newBufferCleaner(MethodHandle unmapper) {
        assert (Objects.equals(MethodType.methodType(Void.TYPE, ByteBuffer.class), unmapper.type()));
        return (resourceDescription, buffer) -> {
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("unmapping only works with direct buffers");
            }
            try {
                unmapper.invokeExact(buffer);
            }
            catch (Throwable t) {
                throw new IOException("Unable to unmap the mapped buffer: " + resourceDescription, t);
            }
        };
    }
}

