/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.search.CoveringScorer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public final class CoveringQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(CoveringQuery.class);
    private final Collection<Query> queries;
    private final LongValuesSource minimumNumberMatch;
    private final int hashCode;
    private final long ramBytesUsed;

    public CoveringQuery(Collection<Query> queries, LongValuesSource minimumNumberMatch) {
        if (queries.size() > IndexSearcher.getMaxClauseCount()) {
            throw new IndexSearcher.TooManyClauses();
        }
        if (minimumNumberMatch.needsScores()) {
            throw new IllegalArgumentException("The minimum number of matches may not depend on the score.");
        }
        this.queries = new Multiset<Query>();
        this.queries.addAll(queries);
        this.minimumNumberMatch = Objects.requireNonNull(minimumNumberMatch);
        this.hashCode = this.computeHashCode();
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.queries, 1024L);
    }

    @Override
    public String toString(String field) {
        String queriesToString = this.queries.stream().map(q -> q.toString(field)).sorted().collect(Collectors.joining(", "));
        return "CoveringQuery(queries=[" + queriesToString + "], minimumNumberMatch=" + this.minimumNumberMatch + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        CoveringQuery that = (CoveringQuery)obj;
        return this.hashCode == that.hashCode && Objects.equals(this.queries, that.queries) && Objects.equals(this.minimumNumberMatch, that.minimumNumberMatch);
    }

    private int computeHashCode() {
        int h = this.classHash();
        h = 31 * h + this.queries.hashCode();
        h = 31 * h + this.minimumNumberMatch.hashCode();
        return h;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.minimumNumberMatch instanceof LongValuesSource.ConstantLongValuesSource) {
            long constantMin = ((LongValuesSource.ConstantLongValuesSource)this.minimumNumberMatch).getValue();
            if (constantMin > (long)this.queries.size()) {
                return new MatchNoDocsQuery("More clauses are required to match than the number of clauses");
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder().setMinimumNumberShouldMatch((int)Math.max(constantMin, 1L));
            for (Query query2 : this.queries) {
                Query r = query2.rewrite(reader);
                builder.add(r, BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
        Multiset<Query> rewritten = new Multiset<Query>();
        boolean actuallyRewritten = false;
        for (Query query3 : this.queries) {
            Query r = query3.rewrite(reader);
            rewritten.add(r);
            actuallyRewritten |= query3 != r;
        }
        if (actuallyRewritten) {
            return new CoveringQuery(rewritten, this.minimumNumberMatch);
        }
        return super.rewrite(reader);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
        for (Query query2 : this.queries) {
            query2.visit(v);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        ArrayList<Weight> weights = new ArrayList<Weight>(this.queries.size());
        for (Query query2 : this.queries) {
            weights.add(searcher.createWeight(query2, scoreMode, boost));
        }
        return new CoveringWeight(this, weights, this.minimumNumberMatch.rewrite(searcher));
    }

    private static class CoveringWeight
    extends Weight {
        private final Collection<Weight> weights;
        private final LongValuesSource minimumNumberMatch;

        CoveringWeight(Query query2, Collection<Weight> weights, LongValuesSource minimumNumberMatch) {
            super(query2);
            this.weights = weights;
            this.minimumNumberMatch = minimumNumberMatch;
        }

        @Override
        public Matches matches(LeafReaderContext context2, int doc) throws IOException {
            LongValues minMatchValues = this.minimumNumberMatch.getValues(context2, null);
            if (!minMatchValues.advanceExact(doc)) {
                return null;
            }
            long minimumNumberMatch = Math.max(1L, minMatchValues.longValue());
            long matchCount = 0L;
            ArrayList<Matches> subMatches = new ArrayList<Matches>();
            for (Weight weight : this.weights) {
                Matches matches = weight.matches(context2, doc);
                if (matches == null) continue;
                ++matchCount;
                subMatches.add(matches);
            }
            if (matchCount < minimumNumberMatch) {
                return null;
            }
            return MatchesUtils.fromSubMatches(subMatches);
        }

        @Override
        public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
            LongValues minMatchValues = this.minimumNumberMatch.getValues(context2, null);
            if (!minMatchValues.advanceExact(doc)) {
                return Explanation.noMatch("minimumNumberMatch has no value on the current document", new Explanation[0]);
            }
            long minimumNumberMatch = Math.max(1L, minMatchValues.longValue());
            int freq = 0;
            double score = 0.0;
            ArrayList<Explanation> subExpls = new ArrayList<Explanation>();
            for (Weight weight : this.weights) {
                Explanation subExpl = weight.explain(context2, doc);
                if (subExpl.isMatch()) {
                    ++freq;
                    score += subExpl.getValue().doubleValue();
                }
                subExpls.add(subExpl);
            }
            if ((long)freq >= minimumNumberMatch) {
                return Explanation.match((Number)Float.valueOf((float)score), freq + " matches for " + minimumNumberMatch + " required matches, sum of:", subExpls);
            }
            return Explanation.noMatch(freq + " matches for " + minimumNumberMatch + " required matches", subExpls);
        }

        @Override
        public Scorer scorer(LeafReaderContext context2) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight w : this.weights) {
                Scorer s = w.scorer(context2);
                if (s == null) continue;
                scorers.add(s);
            }
            if (scorers.isEmpty()) {
                return null;
            }
            return new CoveringScorer(this, scorers, this.minimumNumberMatch.getValues(context2, null), context2.reader().maxDoc());
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.minimumNumberMatch.isCacheable(ctx);
        }
    }
}

