/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.queries.payloads.PayloadDecoder;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.queries.spans.FilterSpans;
import org.apache.lucene.queries.spans.SpanCollector;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanScorer;
import org.apache.lucene.queries.spans.SpanWeight;
import org.apache.lucene.queries.spans.Spans;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;

public class PayloadScoreQuery
extends SpanQuery {
    private final SpanQuery wrappedQuery;
    private final PayloadFunction function;
    private final PayloadDecoder decoder;
    private final boolean includeSpanScore;

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, PayloadDecoder decoder, boolean includeSpanScore) {
        this.wrappedQuery = Objects.requireNonNull(wrappedQuery);
        this.function = Objects.requireNonNull(function);
        this.decoder = Objects.requireNonNull(decoder);
        this.includeSpanScore = includeSpanScore;
    }

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, PayloadDecoder decoder) {
        this(wrappedQuery, function, decoder, true);
    }

    @Override
    public String getField() {
        return this.wrappedQuery.getField();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query matchRewritten = this.wrappedQuery.rewrite(reader);
        if (this.wrappedQuery != matchRewritten && matchRewritten instanceof SpanQuery) {
            return new PayloadScoreQuery((SpanQuery)matchRewritten, this.function, this.decoder, this.includeSpanScore);
        }
        return super.rewrite(reader);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.wrappedQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PayloadScoreQuery(");
        buffer.append(this.wrappedQuery.toString(field));
        buffer.append(", function: ");
        buffer.append(this.function.getClass().getSimpleName());
        buffer.append(", includeSpanScore: ");
        buffer.append(this.includeSpanScore);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        SpanWeight innerWeight = this.wrappedQuery.createWeight(searcher, scoreMode, boost);
        if (!scoreMode.needsScores()) {
            return innerWeight;
        }
        return new PayloadSpanWeight(searcher, innerWeight, boost);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PayloadScoreQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PayloadScoreQuery other) {
        return this.wrappedQuery.equals(other.wrappedQuery) && this.function.equals(other.function) && this.includeSpanScore == other.includeSpanScore && Objects.equals(this.decoder, other.decoder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.wrappedQuery, this.function, this.decoder, this.includeSpanScore);
    }

    private class PayloadSpanScorer
    extends SpanScorer {
        private final PayloadSpans spans;

        private PayloadSpanScorer(SpanWeight weight, PayloadSpans spans, LeafSimScorer docScorer) throws IOException {
            super(weight, spans, docScorer);
            this.spans = spans;
        }

        protected float getPayloadScore() {
            float score = PayloadScoreQuery.this.function.docScore(this.docID(), PayloadScoreQuery.this.getField(), this.spans.payloadsSeen, this.spans.payloadScore);
            if (!(score >= 0.0f)) {
                return 0.0f;
            }
            return score;
        }

        protected Explanation getPayloadExplanation() {
            Explanation expl = PayloadScoreQuery.this.function.explain(this.docID(), PayloadScoreQuery.this.getField(), this.spans.payloadsSeen, this.spans.payloadScore);
            if (expl.getValue().floatValue() < 0.0f) {
                expl = Explanation.match((Number)0, "truncated score, max of:", Explanation.match((Number)Float.valueOf(0.0f), "minimum score", new Explanation[0]), expl);
            } else if (Float.isNaN(expl.getValue().floatValue())) {
                expl = Explanation.match((Number)0, "payload score, computed as (score == NaN ? 0 : score) since NaN is an illegal score from:", expl);
            }
            return expl;
        }

        protected float getSpanScore() throws IOException {
            return super.scoreCurrentDoc();
        }

        @Override
        protected float scoreCurrentDoc() throws IOException {
            if (PayloadScoreQuery.this.includeSpanScore) {
                return this.getSpanScore() * this.getPayloadScore();
            }
            return this.getPayloadScore();
        }
    }

    private class PayloadSpans
    extends FilterSpans
    implements SpanCollector {
        private final PayloadDecoder decoder;
        public int payloadsSeen;
        public float payloadScore;

        private PayloadSpans(Spans in, PayloadDecoder decoder) {
            super(in);
            this.decoder = decoder;
        }

        @Override
        protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
            return FilterSpans.AcceptStatus.YES;
        }

        @Override
        protected void doStartCurrentDoc() {
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
        }

        @Override
        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            BytesRef payload = postings.getPayload();
            float payloadFactor = this.decoder.computePayloadFactor(payload);
            this.payloadScore = PayloadScoreQuery.this.function.currentScore(this.docID(), PayloadScoreQuery.this.getField(), this.in.startPosition(), this.in.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
            ++this.payloadsSeen;
        }

        @Override
        public void reset() {
        }

        @Override
        protected void doCurrentSpans() throws IOException {
            this.in.collect(this);
        }
    }

    private class PayloadSpanWeight
    extends SpanWeight {
        private final SpanWeight innerWeight;

        public PayloadSpanWeight(IndexSearcher searcher, SpanWeight innerWeight, float boost) throws IOException {
            super(PayloadScoreQuery.this, searcher, null, boost);
            this.innerWeight = innerWeight;
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            this.innerWeight.extractTermStates(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
            return this.innerWeight.getSpans(ctx, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
        }

        @Override
        public SpanScorer scorer(LeafReaderContext context2) throws IOException {
            Spans spans = this.getSpans(context2, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            LeafSimScorer docScorer = this.innerWeight.getSimScorer(context2);
            PayloadSpans payloadSpans = new PayloadSpans(spans, PayloadScoreQuery.this.decoder);
            return new PayloadSpanScorer(this, payloadSpans, docScorer);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.innerWeight.isCacheable(ctx);
        }

        @Override
        public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
            PayloadSpanScorer scorer = (PayloadSpanScorer)this.scorer(context2);
            if (scorer == null || scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch("No match", new Explanation[0]);
            }
            scorer.score();
            Explanation payloadExpl = scorer.getPayloadExplanation();
            if (PayloadScoreQuery.this.includeSpanScore) {
                SpanWeight innerWeight = ((PayloadSpanWeight)scorer.getWeight()).innerWeight;
                Explanation innerExpl = innerWeight.explain(context2, doc);
                return Explanation.match((Number)Float.valueOf(scorer.scoreCurrentDoc()), "PayloadSpanQuery, product of:", innerExpl, payloadExpl);
            }
            return scorer.getPayloadExplanation();
        }
    }
}

