/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.irix.IRIs;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.shared.WrappedIOException;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.LocationMapper;
import org.apache.jena.util.Locator;
import org.apache.jena.util.LocatorClassLoader;
import org.apache.jena.util.LocatorFile;
import org.apache.jena.util.LocatorURL;
import org.apache.jena.util.LocatorZip;
import org.apache.jena.util.TypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerImpl
implements FileManager {
    private static Logger log = LoggerFactory.getLogger(FileManager.class);
    static FileManager fmInstance = null;
    protected List<Locator> fmHandlers = new ArrayList<Locator>();
    protected LocationMapper fmMapper = null;
    boolean cacheModelLoads = false;
    Map<String, Model> modelCache = null;

    public static FileManager get() {
        if (fmInstance == null) {
            fmInstance = FileManagerImpl.makeGlobal();
        }
        return fmInstance;
    }

    public static void setGlobalFileManager(FileManager globalFileManager) {
        fmInstance = globalFileManager;
    }

    protected FileManagerImpl() {
    }

    protected static FileManager makeStd() {
        FileManagerImpl fm = new FileManagerImpl();
        FileManagerImpl.setStdLocators(fm);
        return fm;
    }

    protected FileManagerImpl(LocationMapper _mapper) {
        this();
        this.setLocationMapper(_mapper);
    }

    @Override
    public FileManager clone() {
        return FileManagerImpl.clone(this);
    }

    private static FileManager clone(FileManagerImpl filemanager) {
        FileManagerImpl newFm = new FileManagerImpl();
        newFm.fmHandlers.addAll(filemanager.fmHandlers);
        newFm.fmMapper = null;
        if (filemanager.getLocationMapper() != null) {
            newFm.fmMapper = new LocationMapper(filemanager.getLocationMapper());
        }
        newFm.cacheModelLoads = false;
        newFm.modelCache = null;
        return newFm;
    }

    public static FileManager makeGlobal() {
        FileManagerImpl fMgr = new FileManagerImpl(LocationMapper.getInternal());
        FileManagerImpl.setStdLocators(fMgr);
        return fMgr;
    }

    private static void setStdLocators(FileManagerImpl fMgr) {
        fMgr.fmHandlers.clear();
        fMgr.addLocatorFile();
        fMgr.addLocatorURL();
        fMgr.addLocatorClassLoader(fMgr.getClass().getClassLoader());
    }

    @Override
    public void setLocationMapper(LocationMapper _mapper) {
        this.fmMapper = _mapper;
    }

    @Override
    public LocationMapper getLocationMapper() {
        return this.fmMapper;
    }

    @Override
    public Iterator<Locator> locators() {
        return this.fmHandlers.listIterator();
    }

    @Override
    public void addLocator(Locator loc) {
        log.debug("Add location: " + loc.getName());
        this.fmHandlers.add(loc);
    }

    @Override
    @Deprecated
    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    @Override
    @Deprecated
    public void addLocatorFile(String dir) {
        LocatorFile fLoc = new LocatorFile(dir);
        this.addLocator(fLoc);
    }

    @Override
    @Deprecated
    public void addLocatorClassLoader(ClassLoader cLoad) {
        LocatorClassLoader cLoc = new LocatorClassLoader(cLoad);
        this.addLocator(cLoc);
    }

    @Override
    @Deprecated
    public void addLocatorURL() {
        LocatorURL loc = new LocatorURL();
        this.addLocator(loc);
    }

    @Override
    @Deprecated
    public void addLocatorZip(String zfn) {
        LocatorZip loc = new LocatorZip(zfn);
        this.addLocator(loc);
    }

    @Override
    public void remove(Locator loc) {
        this.fmHandlers.remove(loc);
    }

    @Override
    public void resetCache() {
        if (this.modelCache != null) {
            this.modelCache.clear();
        }
    }

    @Override
    public void setModelCaching(boolean state) {
        this.cacheModelLoads = state;
        if (this.cacheModelLoads && this.modelCache == null) {
            this.modelCache = new HashMap<String, Model>();
        }
    }

    @Override
    public boolean isCachingModels() {
        return this.cacheModelLoads;
    }

    @Override
    public Model getFromCache(String filenameOrURI) {
        if (!this.isCachingModels()) {
            return null;
        }
        return this.modelCache.get(filenameOrURI);
    }

    @Override
    public boolean hasCachedModel(String filenameOrURI) {
        if (!this.isCachingModels()) {
            return false;
        }
        return this.modelCache.containsKey(filenameOrURI);
    }

    @Override
    public void addCacheModel(String uri, Model m) {
        if (this.isCachingModels()) {
            this.modelCache.put(uri, m);
        }
    }

    @Override
    public void removeCacheModel(String uri) {
        if (this.isCachingModels()) {
            this.modelCache.remove(uri);
        }
    }

    @Override
    public Model loadModelInternal(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, null);
    }

    @Override
    public Model loadModel(String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, rdfSyntax);
    }

    @Override
    public Model loadModel(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + baseURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, baseURI, rdfSyntax);
    }

    private Model loadModelWorker(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (this.hasCachedModel(filenameOrURI)) {
            if (log.isDebugEnabled()) {
                log.debug("Model cache hit: " + filenameOrURI);
            }
            return this.getFromCache(filenameOrURI);
        }
        Model m = ModelFactory.createDefaultModel();
        this.readModelWorker(m, filenameOrURI, baseURI, rdfSyntax);
        if (this.isCachingModels()) {
            this.addCacheModel(filenameOrURI, m);
        }
        return m;
    }

    @Override
    public Model readModelInternal(Model model, String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ")");
        }
        return this.readModel(model, filenameOrURI, null);
    }

    @Override
    public Model readModel(Model model, String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, null, rdfSyntax);
    }

    @Override
    public Model readModel(Model model, String filenameOrURI, String baseURI, String syntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + baseURI + ", " + syntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, baseURI, syntax);
    }

    protected Model readModelWorker(Model model, String filenameOrURI, String baseURI, String syntax) {
        TypedStream in;
        String mappedURI = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !mappedURI.equals(filenameOrURI)) {
            log.debug("Map: " + filenameOrURI + " => " + mappedURI);
        }
        if (syntax == null && baseURI == null && mappedURI.startsWith("http:")) {
            syntax = FileUtils.guessLang(mappedURI);
            model.read(mappedURI, syntax);
            return model;
        }
        if (syntax == null) {
            syntax = FileUtils.guessLang(mappedURI);
            if (syntax == null || syntax.equals("")) {
                syntax = "RDF/XML";
            }
            if (log.isDebugEnabled()) {
                log.debug("Syntax guess: " + syntax);
            }
        }
        if (baseURI == null) {
            baseURI = FileManagerImpl.chooseBaseURI(filenameOrURI);
        }
        if ((in = this.openNoMapOrNull(mappedURI)) == null) {
            FmtLog.debug(log, "Failed to locate '%s'", mappedURI);
            throw new NotFoundException("Not found: " + filenameOrURI);
        }
        if (in.getMimeType() != null) {
            // empty if block
        }
        model.read(in.getInput(), baseURI, syntax);
        try {
            in.getInput().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return model;
    }

    private static String chooseBaseURI(String baseURI) {
        return IRIs.resolve(baseURI);
    }

    @Override
    public InputStream open(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("open(" + filenameOrURI + ")");
        }
        String uri = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !uri.equals(filenameOrURI)) {
            log.debug("open: mapped to " + uri);
        }
        return this.openNoMap(uri);
    }

    @Override
    public String mapURI(String filenameOrURI) {
        if (this.fmMapper == null) {
            return filenameOrURI;
        }
        String uri = this.fmMapper.altMapping(filenameOrURI, null);
        if (uri == null) {
            if (log.isDebugEnabled()) {
                log.debug("Not mapped: " + filenameOrURI);
            }
            uri = filenameOrURI;
        } else if (log.isDebugEnabled()) {
            log.debug("Mapped: " + filenameOrURI + " => " + uri);
        }
        return uri;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String readWholeFileAsUTF8(InputStream in) {
        try (BufferedReader r = FileUtils.asBufferedUTF8(in);){
            String string;
            try (StringWriter sw = new StringWriter(1024);){
                int l;
                char[] buff = new char[1024];
                while ((l = r.read(buff)) > 0) {
                    sw.write(buff, 0, l);
                }
                string = sw.toString();
            }
            return string;
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex);
        }
    }

    @Override
    public String readWholeFileAsUTF8(String filename) {
        InputStream in = this.open(filename);
        if (in == null) {
            throw new NotFoundException("File not found: " + filename);
        }
        return this.readWholeFileAsUTF8(in);
    }

    @Override
    public InputStream openNoMap(String filenameOrURI) {
        TypedStream in = this.openNoMapOrNull(filenameOrURI);
        if (in == null) {
            return null;
        }
        return in.getInput();
    }

    @Override
    public TypedStream openNoMapOrNull(String filenameOrURI) {
        for (Locator loc : this.fmHandlers) {
            TypedStream in = loc.open(filenameOrURI);
            if (in == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found: " + filenameOrURI + " (" + loc.getName() + ")");
            }
            return in;
        }
        return null;
    }

    static {
        JenaSystem.init();
    }
}

