/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ext.xerces.DatatypeFactoryInst;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValueCmp;
import org.apache.jena.sparql.expr.ValueSpace;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDateTime;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDecimal;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDuration;
import org.apache.jena.sparql.expr.nodevalue.NodeValueFloat;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.expr.nodevalue.NodeValueLang;
import org.apache.jena.sparql.expr.nodevalue.NodeValueNode;
import org.apache.jena.sparql.expr.nodevalue.NodeValueSortKey;
import org.apache.jena.sparql.expr.nodevalue.NodeValueString;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.RomanNumeral;
import org.apache.jena.sparql.util.RomanNumeralDatatype;
import org.apache.jena.sparql.util.Utils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeValue
extends ExprNode {
    private static Logger log;
    public static boolean VerboseWarnings;
    public static boolean VerboseExceptions;
    public static final NodeValue TRUE;
    public static final NodeValue FALSE;
    public static final NodeValue nvZERO;
    public static final NodeValue nvNegZERO;
    public static final NodeValue nvONE;
    public static final NodeValue nvTEN;
    public static final NodeValue nvDecimalZERO;
    public static final NodeValue nvDecimalONE;
    public static final NodeValue nvNaN;
    public static final NodeValue nvINF;
    public static final NodeValue nvNegINF;
    public static final NodeValue nvEmptyString;
    public static final String xsdNamespace = "http://www.w3.org/2001/XMLSchema#";
    public static DatatypeFactory xmlDatatypeFactory;
    private Node node = null;
    private static final String dtXSDprecisionDecimal = "http://www.w3.org/2001/XMLSchema#precisionDecimal";

    protected NodeValue() {
    }

    protected NodeValue(Node n) {
        this.node = n;
    }

    public static NodeValue parse(String string) {
        return NodeValue.makeNode(NodeFactoryExtra.parseNode(string));
    }

    public static NodeValue makeInteger(long i) {
        return new NodeValueInteger(BigInteger.valueOf(i));
    }

    public static NodeValue makeInteger(BigInteger i) {
        return new NodeValueInteger(i);
    }

    public static NodeValue makeInteger(String lexicalForm) {
        return new NodeValueInteger(new BigInteger(lexicalForm));
    }

    public static NodeValue makeFloat(float f) {
        return new NodeValueFloat(f);
    }

    public static NodeValue makeDouble(double d) {
        return new NodeValueDouble(d);
    }

    public static NodeValue makeString(String s) {
        return new NodeValueString(s);
    }

    public static NodeValue makeSortKey(String s, String collation2) {
        return new NodeValueSortKey(s, collation2);
    }

    public static NodeValue makeLangString(String s, String lang) {
        return new NodeValueLang(s, lang);
    }

    public static NodeValue makeDecimal(BigDecimal d) {
        return new NodeValueDecimal(d);
    }

    public static NodeValue makeDecimal(long i) {
        return new NodeValueDecimal(BigDecimal.valueOf(i));
    }

    public static NodeValue makeDecimal(double d) {
        return new NodeValueDecimal(BigDecimal.valueOf(d));
    }

    public static NodeValue makeDecimal(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeDateTime(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDate(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdate);
    }

    public static NodeValue makeDateTime(Calendar cal) {
        String lex = DateTimeUtils.calendarToXSDDateTimeString(cal);
        return NodeValue.makeNode(lex, XSDDatatype.XSDdateTime);
    }

    public static NodeValue makeDateTime(XMLGregorianCalendar cal) {
        String lex = cal.toXMLFormat();
        Node node = NodeFactory.createLiteral(lex, XSDDatatype.XSDdateTime);
        return NodeValueDateTime.create(lex, node);
    }

    public static NodeValue makeDate(Calendar cal) {
        String lex = DateTimeUtils.calendarToXSDDateString(cal);
        return NodeValue.makeNode(lex, XSDDatatype.XSDdate);
    }

    public static NodeValue makeDate(XMLGregorianCalendar cal) {
        String lex = cal.toXMLFormat();
        Node node = NodeFactory.createLiteral(lex, XSDDatatype.XSDdate);
        return NodeValueDateTime.create(lex, node);
    }

    public static NodeValue makeDuration(String lexicalForm) {
        return NodeValue.makeNode(lexicalForm, XSDDatatype.XSDduration);
    }

    public static NodeValue makeDuration(Duration duration) {
        return new NodeValueDuration(duration);
    }

    public static NodeValue makeNodeDuration(Duration duration, Node node) {
        return new NodeValueDuration(duration, node);
    }

    public static NodeValue makeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue booleanReturn(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNode(Node n) {
        NodeValue nv = NodeValue.nodeToNodeValue(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, RDFDatatype dtype) {
        Node n = NodeFactory.createLiteral(lexicalForm, dtype);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return NodeValue.makeNode(lexicalForm, langTag, uri);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, String datatype) {
        if (datatype != null && datatype.equals("")) {
            datatype = null;
        }
        if (langTag != null && datatype != null) {
            Log.warn(NodeValue.class, "Both lang tag and datatype defined (lexcial form '" + lexicalForm + "')");
        }
        Node n = null;
        if (langTag != null) {
            n = NodeFactory.createLiteral(lexicalForm, langTag);
        } else if (datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
            n = NodeFactory.createLiteral(lexicalForm, dType);
        } else {
            n = NodeFactory.createLiteral(lexicalForm);
        }
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNodeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNodeBoolean(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDboolean.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(long v) {
        NodeValue nv = NodeValue.makeNode(Long.toString(v), null, XSDDatatype.XSDinteger.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDinteger.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(float f) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(f), null, XSDDatatype.XSDfloat.getURI());
        return nv;
    }

    public static NodeValue makeNodeFloat(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(double v) {
        NodeValue nv = NodeValue.makeNode(Utils.stringForm(v), null, XSDDatatype.XSDdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDecimal(BigDecimal decimal) {
        String lex = XSDFuncOp.canonicalDecimalStr(decimal);
        return NodeValue.makeNode(lex, XSDDatatype.XSDdecimal);
    }

    public static NodeValue makeNodeDecimal(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSDDatatype.XSDdecimal.getURI());
        return nv;
    }

    public static NodeValue makeNodeString(String string) {
        NodeValue nv = NodeValue.makeNode(string, null, (String)null);
        return nv;
    }

    public static NodeValue makeNodeDateTime(Calendar date2) {
        String lex = DateTimeUtils.calendarToXSDDateTimeString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDateTime(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
        return nv;
    }

    public static NodeValue makeNodeDate(Calendar date2) {
        String lex = DateTimeUtils.calendarToXSDDateString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdate);
        return nv;
    }

    public static NodeValue makeNodeDate(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdate);
        return nv;
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        return this;
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        return this;
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        Node n = this.asNode();
        n = (Node)transform.apply(n);
        return NodeValue.makeNode(n);
    }

    public Node evalNode(Binding binding, ExecutionContext execCxt) {
        return this.asNode();
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public NodeValue getConstant() {
        return this;
    }

    public boolean isIRI() {
        this.forceToNode();
        return this.node.isURI();
    }

    public boolean isBlank() {
        this.forceToNode();
        return this.node.isBlank();
    }

    public boolean isTripleTerm() {
        this.forceToNode();
        return this.node.isNodeTriple();
    }

    public ValueSpace getValueSpace() {
        return NodeValue.classifyValueSpace(this);
    }

    public static ValueSpace classifyValueOp(NodeValue nv1, NodeValue nv2) {
        ValueSpace c2;
        ValueSpace c1 = NodeValue.classifyValueSpace(nv1);
        if (c1 == (c2 = NodeValue.classifyValueSpace(nv2))) {
            return c1;
        }
        if (c1 == ValueSpace.VSPACE_UNKNOWN || c2 == ValueSpace.VSPACE_UNKNOWN) {
            return ValueSpace.VSPACE_UNKNOWN;
        }
        return ValueSpace.VSPACE_DIFFERENT;
    }

    static ValueSpace classifyValueSpace(NodeValue nv) {
        return ValueSpace.valueSpace(nv);
    }

    public static boolean sameValueAs(NodeValue nv1, NodeValue nv2) {
        return NodeValueCmp.sameValueAs(nv1, nv2);
    }

    @Deprecated
    public static boolean sameAs(NodeValue nv1, NodeValue nv2) {
        return NodeValue.sameValueAs(nv1, nv2);
    }

    public static boolean notSameValueAs(Node n1, Node n2) {
        return NodeValue.notSameValueAs(NodeValue.makeNode(n1), NodeValue.makeNode(n2));
    }

    @Deprecated
    public static boolean notSameAs(Node n1, Node n2) {
        return NodeValue.notSameValueAs(n1, n2);
    }

    public static boolean notSameValueAs(NodeValue nv1, NodeValue nv2) {
        return !NodeValue.sameValueAs(nv1, nv2);
    }

    @Deprecated
    public static boolean notSameAs(NodeValue nv1, NodeValue nv2) {
        return NodeValue.notSameValueAs(nv1, nv2);
    }

    public static int compare(NodeValue nv1, NodeValue nv2) {
        int x = NodeValueCmp.compareByValue(nv1, nv2);
        if (x == 2 || x == -9) {
            throw new ExprNotComparableException(null);
        }
        return x;
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        return NodeValueCmp.compareAlways(nv1, nv2);
    }

    public static Node toNode(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public final Node asNode() {
        if (this.node == null) {
            this.node = this.makeNode();
        }
        return this.node;
    }

    protected abstract Node makeNode();

    public Node getNode() {
        return this.node;
    }

    public String getDatatypeURI() {
        return this.asNode().getLiteralDatatypeURI();
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isLangString() {
        return false;
    }

    public boolean isSortKey() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isDecimal() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean hasDateTime() {
        return this.isDateTime() || this.isDate() || this.isTime() || this.isGYear() || this.isGYearMonth() || this.isGMonth() || this.isGMonthDay() || this.isGDay();
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isDate() {
        return false;
    }

    public boolean isLiteral() {
        return this.getNode() == null || this.getNode().isLiteral();
    }

    public boolean isTime() {
        return false;
    }

    public boolean isDuration() {
        return false;
    }

    public boolean isYearMonthDuration() {
        if (!this.isDuration()) {
            return false;
        }
        Duration dur = this.getDuration();
        return (dur.isSet(DatatypeConstants.YEARS) || dur.isSet(DatatypeConstants.MONTHS)) && !dur.isSet(DatatypeConstants.DAYS) && !dur.isSet(DatatypeConstants.HOURS) && !dur.isSet(DatatypeConstants.MINUTES) && !dur.isSet(DatatypeConstants.SECONDS);
    }

    public boolean isDayTimeDuration() {
        if (!this.isDuration()) {
            return false;
        }
        Duration dur = this.getDuration();
        return !dur.isSet(DatatypeConstants.YEARS) && !dur.isSet(DatatypeConstants.MONTHS) && (dur.isSet(DatatypeConstants.DAYS) || dur.isSet(DatatypeConstants.HOURS) || dur.isSet(DatatypeConstants.MINUTES) || dur.isSet(DatatypeConstants.SECONDS));
    }

    public boolean isGYear() {
        return false;
    }

    public boolean isGYearMonth() {
        return false;
    }

    public boolean isGMonth() {
        return false;
    }

    public boolean isGMonthDay() {
        return false;
    }

    public boolean isGDay() {
        return false;
    }

    public boolean getBoolean() {
        NodeValue.raise(new ExprEvalTypeException("Not a boolean: " + this));
        return false;
    }

    public String getString() {
        NodeValue.raise(new ExprEvalTypeException("Not a string: " + this));
        return null;
    }

    public String getLang() {
        NodeValue.raise(new ExprEvalTypeException("Not a string: " + this));
        return null;
    }

    public NodeValueSortKey getSortKey() {
        NodeValue.raise(new ExprEvalTypeException("Not a sort key: " + this));
        return null;
    }

    public BigInteger getInteger() {
        NodeValue.raise(new ExprEvalTypeException("Not an integer: " + this));
        return null;
    }

    public BigDecimal getDecimal() {
        NodeValue.raise(new ExprEvalTypeException("Not a decimal: " + this));
        return null;
    }

    public float getFloat() {
        NodeValue.raise(new ExprEvalTypeException("Not a float: " + this));
        return Float.NaN;
    }

    public double getDouble() {
        NodeValue.raise(new ExprEvalTypeException("Not a double: " + this));
        return Double.NaN;
    }

    public XMLGregorianCalendar getDateTime() {
        NodeValue.raise(new ExprEvalTypeException("No DateTime value: " + this));
        return null;
    }

    public Duration getDuration() {
        NodeValue.raise(new ExprEvalTypeException("Not a duration: " + this));
        return null;
    }

    private static NodeValue nodeToNodeValue(Node node) {
        boolean isPlainLiteral;
        if (node.isVariable()) {
            Log.warn(NodeValue.class, "Variable passed to NodeValue.nodeToNodeValue");
        }
        if (!node.isLiteral()) {
            return new NodeValueNode(node);
        }
        boolean hasLangTag = NodeUtils.isLangString(node);
        boolean bl = isPlainLiteral = node.getLiteralDatatypeURI() == null && !hasLangTag;
        if (isPlainLiteral) {
            return new NodeValueString(node.getLiteralLexicalForm(), node);
        }
        if (hasLangTag) {
            if (node.getLiteralDatatype() != null && !RDF.dtLangString.equals(node.getLiteralDatatype()) && VerboseWarnings) {
                Log.warn(NodeValue.class, "Lang tag and datatype (datatype ignored)");
            }
            return new NodeValueLang(node);
        }
        LiteralLabel lit = node.getLiteral();
        if (!node.getLiteral().isWellFormed()) {
            if (VerboseWarnings) {
                String tmp = FmtUtils.stringForNode(node);
                Log.warn(NodeValue.class, "Datatype format exception: " + tmp);
            }
            return new NodeValueNode(node);
        }
        NodeValue nv = NodeValue._setByValue(node);
        if (nv != null) {
            return nv;
        }
        return new NodeValueNode(node);
    }

    private static NodeValue _setByValue(Node node) {
        if (NodeUtils.hasLang(node)) {
            return new NodeValueLang(node);
        }
        LiteralLabel lit = node.getLiteral();
        RDFDatatype datatype = lit.getDatatype();
        String datatypeURI = datatype.getURI();
        if (!datatypeURI.startsWith(xsdNamespace) && !SystemARQ.EnableRomanNumerals) {
            return null;
        }
        String lex = lit.getLexicalForm();
        try {
            if (XSDDatatype.XSDstring.isValidLiteral(lit)) {
                return new NodeValueString(lex, node);
            }
            String lexTrimmed = lex.trim();
            if (!datatype.equals(XSDDatatype.XSDdecimal) && XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                String s = lexTrimmed;
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                BigInteger integer = new BigInteger(s);
                return new NodeValueInteger(integer, node);
            }
            if (datatype.equals(XSDDatatype.XSDdecimal) && XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                BigDecimal decimal = new BigDecimal(lexTrimmed);
                return new NodeValueDecimal(decimal, node);
            }
            if (datatype.equals(XSDDatatype.XSDfloat) && XSDDatatype.XSDfloat.isValidLiteral(lit)) {
                float f = ((Number)lit.getValue()).floatValue();
                return new NodeValueFloat(f, node);
            }
            if (datatype.equals(XSDDatatype.XSDdouble) && XSDDatatype.XSDdouble.isValidLiteral(lit)) {
                double d = ((Number)lit.getValue()).doubleValue();
                return new NodeValueDouble(d, node);
            }
            if (datatype.equals(XSDDatatype.XSDboolean) && XSDDatatype.XSDboolean.isValidLiteral(lit)) {
                boolean b = (Boolean)lit.getValue();
                return new NodeValueBoolean(b, node);
            }
            if ((datatype.equals(XSDDatatype.XSDdateTime) || datatype.equals(XSDDatatype.XSDdateTimeStamp)) && XSDDatatype.XSDdateTime.isValid(lex)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDdate) && XSDDatatype.XSDdate.isValidLiteral(lit)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDtime) && XSDDatatype.XSDtime.isValidLiteral(lit)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDgYear) && XSDDatatype.XSDgYear.isValidLiteral(lit)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDgYearMonth) && XSDDatatype.XSDgYearMonth.isValidLiteral(lit)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDgMonth) && XSDDatatype.XSDgMonth.isValidLiteral(lit)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDgMonthDay) && XSDDatatype.XSDgMonthDay.isValidLiteral(lit)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDgDay) && XSDDatatype.XSDgDay.isValidLiteral(lit)) {
                return NodeValueDateTime.create(lexTrimmed, node);
            }
            if (datatype.equals(XSDDatatype.XSDduration) && XSDDatatype.XSDduration.isValid(lex)) {
                Duration duration = xmlDatatypeFactory.newDuration(lexTrimmed);
                return new NodeValueDuration(duration, node);
            }
            if (datatype.equals(XSDDatatype.XSDyearMonthDuration) && XSDDatatype.XSDyearMonthDuration.isValid(lex)) {
                Duration duration = xmlDatatypeFactory.newDuration(lexTrimmed);
                return new NodeValueDuration(duration, node);
            }
            if (datatype.equals(XSDDatatype.XSDdayTimeDuration) && XSDDatatype.XSDdayTimeDuration.isValid(lex)) {
                Duration duration = xmlDatatypeFactory.newDuration(lexTrimmed);
                return new NodeValueDuration(duration, node);
            }
            if (SystemARQ.EnableRomanNumerals && lit.getDatatypeURI().equals(RomanNumeralDatatype.get().getURI())) {
                Object obj = RomanNumeralDatatype.get().parse(lexTrimmed);
                if (obj instanceof Integer) {
                    return new NodeValueInteger(((Integer)obj).longValue());
                }
                if (obj instanceof RomanNumeral) {
                    return new NodeValueInteger(((RomanNumeral)obj).intValue());
                }
                throw new ARQInternalErrorException("DatatypeFormatException: Roman numeral is unknown class");
            }
        }
        catch (DatatypeFormatException ex) {
            throw new ARQInternalErrorException("DatatypeFormatException: " + lit, ex);
        }
        return null;
    }

    public static void raise(ExprException ex) {
        throw ex;
    }

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    private void forceToNode() {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node == null) {
            NodeValue.raise(new ExprEvalException("Not a node: " + this));
        }
    }

    public final String asUnquotedString() {
        return this.asString();
    }

    public final String asQuotedString() {
        return this.asQuotedString(new SerializationContext());
    }

    public final String asQuotedString(SerializationContext context2) {
        if (this.node == null) {
            this.node = this.asNode();
        }
        if (this.node != null) {
            return FmtUtils.stringForNode(this.node, context2);
        }
        return this.toString();
    }

    public String asString() {
        this.forceToNode();
        return NodeFunctions.str(this.node);
    }

    @Override
    public int hashCode() {
        return this.asNode().hashCode();
    }

    @Override
    public boolean equals(Expr other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeValue)) {
            return false;
        }
        NodeValue nv = (NodeValue)other;
        return this.asNode().equals(nv.asNode());
    }

    public abstract void visit(NodeValueVisitor var1);

    public Expr apply(ExprTransform transform) {
        return transform.transform(this);
    }

    @Override
    public String toString() {
        return this.asQuotedString();
    }

    static {
        JenaSystem.init();
        log = LoggerFactory.getLogger(NodeValue.class);
        VerboseWarnings = true;
        VerboseExceptions = false;
        TRUE = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
        FALSE = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
        nvZERO = NodeValue.makeNode(NodeConst.nodeZero);
        nvNegZERO = NodeValue.makeNode("-0.0e0", XSDDatatype.XSDdouble);
        nvONE = NodeValue.makeNode(NodeConst.nodeOne);
        nvTEN = NodeValue.makeNode(NodeConst.nodeTen);
        nvDecimalZERO = NodeValue.makeNode("0.0", XSDDatatype.XSDdecimal);
        nvDecimalONE = NodeValue.makeNode("1.0", XSDDatatype.XSDdecimal);
        nvNaN = NodeValue.makeNode("NaN", XSDDatatype.XSDdouble);
        nvINF = NodeValue.makeNode("INF", XSDDatatype.XSDdouble);
        nvNegINF = NodeValue.makeNode("-INF", XSDDatatype.XSDdouble);
        nvEmptyString = NodeValue.makeString("");
        xmlDatatypeFactory = null;
        xmlDatatypeFactory = DatatypeFactoryInst.newDatatypeFactory();
    }
}

