/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.List;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprUndefFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.function.scripting.ScriptFunction;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;

public class E_Function
extends ExprFunctionN {
    private static final String name = "function";
    public static boolean WarnOnUnknownFunction = true;
    private String functionIRI;
    private Function function = null;
    private boolean functionBound = false;

    public E_Function(String functionIRI, ExprList args) {
        super(name, args);
        this.functionIRI = functionIRI;
        if (ScriptFunction.isScriptFunction(functionIRI)) {
            this.function = new ScriptFunction();
        }
    }

    @Override
    public String getFunctionIRI() {
        return this.functionIRI;
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        if (!this.functionBound) {
            this.buildFunction(env.getContext());
        }
        if (this.function == null) {
            throw new ExprEvalException("URI <" + this.getFunctionIRI() + "> not bound");
        }
        NodeValue r = this.function.exec(binding, this.args, this.getFunctionIRI(), env);
        return r;
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        throw new ARQInternalErrorException();
    }

    public void buildFunction(Context cxt) {
        block2: {
            try {
                this.bindFunction(cxt);
            }
            catch (ExprUndefFunction ex) {
                if (!WarnOnUnknownFunction) break block2;
                ARQ.getExecLogger().warn("URI <" + this.functionIRI + "> has no registered function factory");
            }
        }
    }

    private FunctionFactory functionFactory(Context cxt) {
        FunctionRegistry registry = this.chooseRegistry(cxt);
        FunctionFactory ff = registry.get(this.functionIRI);
        return ff;
    }

    private void bindFunction(Context cxt) {
        if (this.functionBound) {
            return;
        }
        if (this.function == null) {
            FunctionFactory ff = this.functionFactory(cxt);
            if (ff == null) {
                this.functionBound = true;
                throw new ExprUndefFunction("URI <" + this.functionIRI + "> not found as a function", this.functionIRI);
            }
            this.function = ff.create(this.functionIRI);
        }
        this.function.build(this.functionIRI, this.args);
        this.functionBound = true;
    }

    private FunctionRegistry chooseRegistry(Context context2) {
        FunctionRegistry registry = FunctionRegistry.get(context2);
        if (registry == null) {
            registry = FunctionRegistry.get();
        }
        return registry;
    }

    @Override
    public String getFunctionPrintName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.functionIRI, cxt);
    }

    @Override
    public String getFunctionName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.functionIRI, cxt);
    }

    @Override
    public Expr copy(ExprList newArgs) {
        return new E_Function(this.getFunctionIRI(), newArgs);
    }
}

