/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecDatasetBuilder;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionCompat
extends QueryExecutionAdapter {
    private final QueryExecMod qExecBuilder;
    private QueryExec qExecHere = null;
    private final Dataset datasetHere;
    private final Query queryHere;

    public static QueryExecution compatibility(QueryExecMod qExec, Dataset dataset, Query query2, String queryString) {
        return new QueryExecutionCompat(qExec, dataset, query2);
    }

    private QueryExecutionCompat(QueryExecMod qExecBuilder, Dataset dataset, Query query2) {
        super(null);
        this.qExecBuilder = qExecBuilder;
        this.datasetHere = dataset;
        this.queryHere = query2;
    }

    @Override
    protected QueryExec get() {
        this.execution();
        return this.qExecHere;
    }

    private void execution() {
        if (this.qExecHere == null) {
            this.qExecHere = this.qExecBuilder.build();
        }
    }

    @Override
    public void setInitialBinding(Binding binding) {
        if (!(this.qExecBuilder instanceof QueryExecDatasetBuilder)) {
            throw new UnsupportedOperationException("setInitialBinding");
        }
        ((QueryExecDatasetBuilder)this.qExecBuilder).initialBinding(binding);
    }

    @Override
    public Dataset getDataset() {
        return this.datasetHere;
    }

    @Override
    public Context getContext() {
        return this.qExecBuilder.getContext();
    }

    @Override
    public Query getQuery() {
        if (this.queryHere != null) {
            return this.queryHere;
        }
        this.execution();
        return this.qExecHere.getQuery();
    }

    @Override
    public ResultSet execSelect() {
        this.execution();
        return super.execSelect();
    }

    @Override
    public Model execConstruct() {
        this.execution();
        return super.execConstruct();
    }

    @Override
    public Model execConstruct(Model model) {
        this.execution();
        return super.execConstruct(model);
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        this.execution();
        return super.execConstructTriples();
    }

    @Override
    public Iterator<Quad> execConstructQuads() {
        this.execution();
        return super.execConstructQuads();
    }

    @Override
    public Dataset execConstructDataset() {
        this.execution();
        return super.execConstructDataset();
    }

    @Override
    public Dataset execConstructDataset(Dataset dataset) {
        this.execution();
        return super.execConstructDataset(dataset);
    }

    @Override
    public Model execDescribe() {
        this.execution();
        return super.execDescribe();
    }

    @Override
    public Model execDescribe(Model model) {
        this.execution();
        return super.execDescribe(model);
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        this.execution();
        return super.execDescribeTriples();
    }

    @Override
    public boolean execAsk() {
        this.execution();
        return super.execAsk();
    }

    @Override
    public JsonArray execJson() {
        this.execution();
        return super.execJson();
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        this.execution();
        return super.execJsonItems();
    }

    @Override
    public void abort() {
        this.execution();
        super.abort();
    }

    @Override
    public void close() {
        this.execution();
        super.close();
    }

    @Override
    public boolean isClosed() {
        if (this.qExecHere == null) {
            return false;
        }
        return this.qExecHere.isClosed();
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        this.qExecBuilder.timeout(timeout, timeoutUnits);
    }

    @Override
    public void setTimeout(long timeout) {
        this.qExecBuilder.timeout(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.qExecBuilder.initialTimeout(timeout1, timeUnit1);
        this.qExecBuilder.overallTimeout(timeout2, timeUnit2);
    }

    @Override
    public void setTimeout(long timeout1, long timeout2) {
        this.qExecBuilder.initialTimeout(timeout1, TimeUnit.MILLISECONDS);
        this.qExecBuilder.overallTimeout(timeout2, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getTimeout1() {
        return -1L;
    }

    @Override
    public long getTimeout2() {
        return -1L;
    }

    @Override
    public void setInitialBinding(QuerySolution querySolution) {
        this.setInitialBinding(BindingLib.toBinding(querySolution));
    }
}

