/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterAssign;
import org.apache.jena.sparql.engine.iterator.QueryIterDiff;
import org.apache.jena.sparql.engine.iterator.QueryIterDistinct;
import org.apache.jena.sparql.engine.iterator.QueryIterDistinguishedVars;
import org.apache.jena.sparql.engine.iterator.QueryIterFilterExpr;
import org.apache.jena.sparql.engine.iterator.QueryIterGroup;
import org.apache.jena.sparql.engine.iterator.QueryIterLateral;
import org.apache.jena.sparql.engine.iterator.QueryIterMinus;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPath;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterProcedure;
import org.apache.jena.sparql.engine.iterator.QueryIterProject;
import org.apache.jena.sparql.engine.iterator.QueryIterProjectMerge;
import org.apache.jena.sparql.engine.iterator.QueryIterReduced;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.engine.iterator.QueryIterSlice;
import org.apache.jena.sparql.engine.iterator.QueryIterSort;
import org.apache.jena.sparql.engine.iterator.QueryIterTopN;
import org.apache.jena.sparql.engine.join.Join;
import org.apache.jena.sparql.engine.main.ExecutionDispatch;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.StageBuilder;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.sparql.engine.main.iterator.QueryIterGraph;
import org.apache.jena.sparql.engine.main.iterator.QueryIterOptionalIndex;
import org.apache.jena.sparql.engine.main.iterator.QueryIterUnion;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.procedure.ProcEval;
import org.apache.jena.sparql.procedure.Procedure;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;

public class OpExecutor {
    public static final OpExecutorFactory stdFactory = new OpExecutorFactory(){

        @Override
        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutor(execCxt);
        }
    };
    protected ExecutionContext execCxt;
    protected ExecutionDispatch dispatcher = null;
    protected static final int TOP_LEVEL = 0;
    protected int level = -1;
    private final boolean hideBNodeVars;
    protected final StageGenerator stageGenerator;

    private static OpExecutor createOpExecutor(ExecutionContext execCxt) {
        OpExecutorFactory factory = execCxt.getExecutor();
        if (factory == null) {
            factory = stdFactory;
        }
        if (factory == null) {
            return new OpExecutor(execCxt);
        }
        return factory.create(execCxt);
    }

    static QueryIterator execute(Op op, ExecutionContext execCxt) {
        return OpExecutor.execute(op, OpExecutor.createRootQueryIterator(execCxt), execCxt);
    }

    static QueryIterator execute(Op op, QueryIterator qIter, ExecutionContext execCxt) {
        OpExecutor exec = OpExecutor.createOpExecutor(execCxt);
        QueryIterator q = exec.exec(op, qIter);
        return q;
    }

    protected OpExecutor(ExecutionContext execCxt) {
        this.execCxt = execCxt;
        this.dispatcher = new ExecutionDispatch(this);
        this.hideBNodeVars = execCxt.getContext().isTrue(ARQ.hideNonDistiguishedVariables);
        this.stageGenerator = StageBuilder.chooseStageGenerator(execCxt.getContext());
    }

    public QueryIterator executeOp(Op op, QueryIterator input) {
        return this.exec(op, input);
    }

    protected QueryIterator exec(Op op, QueryIterator input) {
        ++this.level;
        QueryIterator qIter = this.dispatcher.exec(op, input);
        --this.level;
        return qIter;
    }

    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        BasicPattern pattern = opBGP.getPattern();
        QueryIterator qIter = this.stageGenerator.execute(pattern, input, this.execCxt);
        if (this.hideBNodeVars) {
            qIter = new QueryIterDistinguishedVars(qIter, this.execCxt);
        }
        return qIter;
    }

    protected QueryIterator execute(OpTriple opTriple, QueryIterator input) {
        return this.execute(opTriple.asBGP(), input);
    }

    protected QueryIterator execute(OpGraph opGraph, QueryIterator input) {
        QueryIterator qIter = this.specialcase(opGraph.getNode(), opGraph.getSubOp(), input);
        if (qIter != null) {
            return qIter;
        }
        return new QueryIterGraph(input, opGraph, this.execCxt);
    }

    private QueryIterator specialcase(Node gn, Op subOp, QueryIterator input) {
        if (Quad.isDefaultGraph(gn)) {
            ExecutionContext cxt2 = new ExecutionContext(this.execCxt, this.execCxt.getDataset().getDefaultGraph());
            return OpExecutor.execute(subOp, input, cxt2);
        }
        return null;
    }

    protected QueryIterator execute(OpQuad opQuad, QueryIterator input) {
        return this.execute(opQuad.asQuadPattern(), input);
    }

    protected QueryIterator execute(OpQuadPattern quadPattern, QueryIterator input) {
        if (quadPattern.isDefaultGraph() && this.execCxt.getActiveGraph() == this.execCxt.getDataset().getDefaultGraph()) {
            OpBGP opBGP = new OpBGP(quadPattern.getBasicPattern());
            return this.execute(opBGP, input);
        }
        OpBGP opBGP = new OpBGP(quadPattern.getBasicPattern());
        OpGraph op = new OpGraph(quadPattern.getGraphNode(), opBGP);
        return this.execute(op, input);
    }

    protected QueryIterator execute(OpQuadBlock quadBlock, QueryIterator input) {
        Op op = quadBlock.convertOp();
        return this.exec(op, input);
    }

    protected QueryIterator execute(OpPath opPath, QueryIterator input) {
        return new QueryIterPath(opPath.getTriplePath(), input, this.execCxt);
    }

    protected QueryIterator execute(OpProcedure opProc, QueryIterator input) {
        Procedure procedure = ProcEval.build(opProc, this.execCxt);
        QueryIterator qIter = this.exec(opProc.getSubOp(), input);
        return new QueryIterProcedure(qIter, procedure, this.execCxt);
    }

    protected QueryIterator execute(OpPropFunc opPropFunc, QueryIterator input) {
        Procedure procedure = ProcEval.build(opPropFunc.getProperty(), opPropFunc.getSubjectArgs(), opPropFunc.getObjectArgs(), this.execCxt);
        QueryIterator qIter = this.exec(opPropFunc.getSubOp(), input);
        return new QueryIterProcedure(qIter, procedure, this.execCxt);
    }

    protected QueryIterator execute(OpJoin opJoin, QueryIterator input) {
        QueryIterator left = this.exec(opJoin.getLeft(), input);
        QueryIterator right = this.exec(opJoin.getRight(), this.root());
        QueryIterator qIter = Join.join(left, right, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpSequence opSequence, QueryIterator input) {
        QueryIterator qIter = input;
        Iterator<Op> iter = opSequence.iterator();
        while (iter.hasNext()) {
            Op sub = iter.next();
            qIter = this.exec(sub, qIter);
        }
        return qIter;
    }

    protected QueryIterator execute(OpLeftJoin opLeftJoin, QueryIterator input) {
        QueryIterator left = this.exec(opLeftJoin.getLeft(), input);
        QueryIterator right = this.exec(opLeftJoin.getRight(), this.root());
        QueryIterator qIter = Join.leftJoin(left, right, opLeftJoin.getExprs(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpLateral opLateral, QueryIterator input) {
        QueryIterator left = this.exec(opLateral.getLeft(), input);
        QueryIterLateral qIter = new QueryIterLateral(left, opLateral.getRight(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpConditional opCondition, QueryIterator input) {
        QueryIterator left = this.exec(opCondition.getLeft(), input);
        QueryIterOptionalIndex qIter = new QueryIterOptionalIndex(left, opCondition.getRight(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpDiff opDiff, QueryIterator input) {
        QueryIterator left = this.exec(opDiff.getLeft(), input);
        QueryIterator right = this.exec(opDiff.getRight(), this.root());
        return new QueryIterDiff(left, right, this.execCxt);
    }

    protected QueryIterator execute(OpMinus opMinus, QueryIterator input) {
        Op lhsOp = opMinus.getLeft();
        Op rhsOp = opMinus.getRight();
        QueryIterator left = this.exec(lhsOp, input);
        QueryIterator right = this.exec(rhsOp, this.root());
        Set<Var> commonVars = OpVars.visibleVars(lhsOp);
        commonVars.retainAll(OpVars.visibleVars(rhsOp));
        return QueryIterMinus.create(left, right, commonVars, this.execCxt);
    }

    protected QueryIterator execute(OpDisjunction opDisjunction, QueryIterator input) {
        QueryIterUnion cIter = new QueryIterUnion(input, opDisjunction.getElements(), this.execCxt);
        return cIter;
    }

    protected QueryIterator execute(OpUnion opUnion, QueryIterator input) {
        List<Op> x = this.flattenUnion(opUnion);
        QueryIterUnion cIter = new QueryIterUnion(input, x, this.execCxt);
        return cIter;
    }

    protected List<Op> flattenUnion(OpUnion opUnion) {
        ArrayList<Op> x = new ArrayList<Op>();
        this.flattenUnion(x, opUnion);
        return x;
    }

    protected void flattenUnion(List<Op> acc, OpUnion opUnion) {
        if (opUnion.getLeft() instanceof OpUnion) {
            this.flattenUnion(acc, (OpUnion)opUnion.getLeft());
        } else {
            acc.add(opUnion.getLeft());
        }
        if (opUnion.getRight() instanceof OpUnion) {
            this.flattenUnion(acc, (OpUnion)opUnion.getRight());
        } else {
            acc.add(opUnion.getRight());
        }
    }

    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        ExprList exprs = opFilter.getExprs();
        Op base = opFilter.getSubOp();
        QueryIterator qIter = this.exec(base, input);
        for (Expr expr : exprs) {
            qIter = new QueryIterFilterExpr(qIter, expr, this.execCxt);
        }
        return qIter;
    }

    protected QueryIterator execute(OpService opService, QueryIterator input) {
        return ServiceExecutorRegistry.exec(input, opService, this.execCxt);
    }

    protected QueryIterator execute(OpDatasetNames dsNames, QueryIterator input) {
        throw new ARQNotImplemented("execute/OpDatasetNames");
    }

    protected QueryIterator execute(OpTable opTable, QueryIterator input) {
        if (opTable.isJoinIdentity()) {
            return input;
        }
        if (input.isJoinIdentity()) {
            input.close();
            return opTable.getTable().iterator(this.execCxt);
        }
        QueryIterator qIterT = opTable.getTable().iterator(this.execCxt);
        QueryIterator qIter = Join.join(input, qIterT, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpExt opExt, QueryIterator input) {
        try {
            QueryIterator qIter = opExt.eval(input, this.execCxt);
            if (qIter != null) {
                return qIter;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        throw new QueryExecException("Encountered unsupported OpExt: " + opExt.getName());
    }

    protected QueryIterator execute(OpLabel opLabel, QueryIterator input) {
        if (!opLabel.hasSubOp()) {
            return input;
        }
        return this.exec(opLabel.getSubOp(), input);
    }

    protected QueryIterator execute(OpNull opNull, QueryIterator input) {
        input.close();
        return QueryIterNullIterator.create(this.execCxt);
    }

    protected QueryIterator execute(OpList opList, QueryIterator input) {
        return this.exec(opList.getSubOp(), input);
    }

    protected QueryIterator execute(OpOrder opOrder, QueryIterator input) {
        QueryIterator qIter = this.exec(opOrder.getSubOp(), input);
        qIter = new QueryIterSort(qIter, opOrder.getConditions(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpTopN opTop, QueryIterator input) {
        QueryIterator qIter = null;
        if (opTop.getSubOp() instanceof OpDistinct) {
            OpDistinct opDistinct = (OpDistinct)opTop.getSubOp();
            qIter = this.exec(opDistinct.getSubOp(), input);
            qIter = new QueryIterTopN(qIter, opTop.getConditions(), (long)opTop.getLimit(), true, this.execCxt);
        } else {
            qIter = this.exec(opTop.getSubOp(), input);
            qIter = new QueryIterTopN(qIter, opTop.getConditions(), (long)opTop.getLimit(), false, this.execCxt);
        }
        return qIter;
    }

    protected QueryIterator execute(OpProject opProject, QueryIterator input) {
        if (input instanceof QueryIterRoot) {
            QueryIterator qIter = this.exec(opProject.getSubOp(), input);
            qIter = new QueryIterProject(qIter, opProject.getVars(), this.execCxt);
            return qIter;
        }
        QueryIterProjectMerge qIter = new QueryIterProjectMerge(opProject, input, this, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpSlice opSlice, QueryIterator input) {
        QueryIterator qIter = this.exec(opSlice.getSubOp(), input);
        qIter = new QueryIterSlice(qIter, opSlice.getStart(), opSlice.getLength(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpGroup opGroup, QueryIterator input) {
        QueryIterator qIter = this.exec(opGroup.getSubOp(), input);
        qIter = new QueryIterGroup(qIter, opGroup.getGroupVars(), opGroup.getAggregators(), this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpDistinct opDistinct, QueryIterator input) {
        QueryIterator qIter = this.exec(opDistinct.getSubOp(), input);
        List<SortCondition> conditions = null;
        if (opDistinct.getSubOp() instanceof OpOrder) {
            OpOrder subOrder = (OpOrder)opDistinct.getSubOp();
            conditions = subOrder.getConditions();
        }
        qIter = new QueryIterDistinct(qIter, conditions, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpReduced opReduced, QueryIterator input) {
        QueryIterator qIter = this.exec(opReduced.getSubOp(), input);
        qIter = new QueryIterReduced(qIter, this.execCxt);
        return qIter;
    }

    protected QueryIterator execute(OpAssign opAssign, QueryIterator input) {
        QueryIterator qIter = this.exec(opAssign.getSubOp(), input);
        qIter = new QueryIterAssign(qIter, opAssign.getVarExprList(), this.execCxt, false);
        return qIter;
    }

    protected QueryIterator execute(OpExtend opExtend, QueryIterator input) {
        QueryIterator qIter = this.exec(opExtend.getSubOp(), input);
        qIter = new QueryIterAssign(qIter, opExtend.getVarExprList(), this.execCxt, true);
        return qIter;
    }

    public static QueryIterator createRootQueryIterator(ExecutionContext execCxt) {
        return QueryIterRoot.create(execCxt);
    }

    protected QueryIterator root() {
        return OpExecutor.createRootQueryIterator(this.execCxt);
    }

    private QueryIterator debug(String marker, QueryIterator input) {
        List<Binding> x = OpExecutor.all(input);
        for (Binding b : x) {
            System.out.print(marker);
            System.out.print(": ");
            System.out.println(b);
        }
        return QueryIterPlainWrapper.create(x.iterator(), this.execCxt);
    }

    private static List<Binding> all(QueryIterator input) {
        return Iter.toList(input);
    }
}

