/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;

public class ExecutionContext
implements FunctionEnv {
    private static final boolean TrackAllIterators = false;
    private Context context = null;
    private DatasetGraph dataset = null;
    private final Collection<QueryIterator> openIterators;
    private Collection<QueryIterator> allIterators = null;
    private Graph activeGraph = null;
    private OpExecutorFactory executor = null;
    private final AtomicBoolean cancelSignal;

    public ExecutionContext(ExecutionContext other) {
        this.context = other.context;
        this.dataset = other.dataset;
        this.openIterators = other.openIterators;
        this.allIterators = other.allIterators;
        this.activeGraph = other.activeGraph;
        this.executor = other.executor;
        this.cancelSignal = other.cancelSignal;
    }

    public ExecutionContext(ExecutionContext other, Graph activeGraph) {
        this(other);
        this.activeGraph = activeGraph;
    }

    public ExecutionContext(DatasetGraph dataset) {
        this(dataset, QC.getFactory(ARQ.getContext()));
    }

    public ExecutionContext(DatasetGraph dataset, OpExecutorFactory factory) {
        this(ARQ.getContext().copy(), dataset.getDefaultGraph(), dataset, factory);
    }

    public ExecutionContext(Context params, Graph activeGraph, DatasetGraph dataset, OpExecutorFactory factory) {
        this(params, activeGraph, dataset, factory, ExecutionContext.cancellationSignal(params));
    }

    private static AtomicBoolean cancellationSignal(Context cxt) {
        if (cxt == null) {
            return null;
        }
        try {
            return (AtomicBoolean)cxt.get(ARQConstants.symCancelQuery);
        }
        catch (ClassCastException ex) {
            Log.error(ExecutionContext.class, "Class cast exception: Expected AtomicBoolean for cancel control: " + ex.getMessage());
            return null;
        }
    }

    private ExecutionContext(Context params, Graph activeGraph, DatasetGraph dataset, OpExecutorFactory factory, AtomicBoolean cancelSignal) {
        this.context = params;
        this.dataset = dataset;
        this.openIterators = new ArrayList<QueryIterator>();
        this.activeGraph = activeGraph;
        this.executor = factory;
        this.cancelSignal = cancelSignal;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public AtomicBoolean getCancelSignal() {
        return this.cancelSignal;
    }

    public void openIterator(QueryIterator qIter) {
        this.openIterators.add(qIter);
        if (this.allIterators != null) {
            this.allIterators.add(qIter);
        }
    }

    public void closedIterator(QueryIterator qIter) {
        this.openIterators.remove(qIter);
    }

    public Iterator<QueryIterator> listOpenIterators() {
        return this.openIterators.iterator();
    }

    public Iterator<QueryIterator> listAllIterators() {
        if (this.allIterators == null) {
            return null;
        }
        return this.allIterators.iterator();
    }

    public OpExecutorFactory getExecutor() {
        return this.executor;
    }

    public void setExecutor(OpExecutorFactory executor) {
        this.executor = executor;
    }

    @Override
    public DatasetGraph getDataset() {
        return this.dataset;
    }

    @Override
    public Graph getActiveGraph() {
        return this.activeGraph;
    }
}

