/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.semact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.expressions.SemAct;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.semact.ExtractVar;
import org.apache.jena.shex.semact.SemanticActionPlugin;

public class TestSemanticActionPlugin
implements SemanticActionPlugin {
    static String SemActIri = "http://shex.io/extensions/Test/";
    static Pattern ParsePattern;
    static Pattern LeadPattern;
    static Pattern LastPattern;
    static Pattern ParsePatter1;
    List<String> out = new ArrayList<String>();

    @Override
    public List<String> getUris() {
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(SemActIri);
        return uris;
    }

    public List<String> getOut() {
        return this.out;
    }

    @Override
    public boolean evaluateStart(SemAct semAct, ShexSchema schema) {
        return this.parse(semAct, str2 -> TestSemanticActionPlugin.resolveStartVar(str2));
    }

    @Override
    public boolean evaluateShapeExpr(SemAct semAct, ShapeExpression shapeExpression, Node focus) {
        return this.parse(semAct, str2 -> TestSemanticActionPlugin.resolveNodeVar(str2, focus));
    }

    @Override
    public boolean evaluateTripleExpr(SemAct semAct, TripleExpression tripleExpression, Collection<Triple> triples) {
        Iterator<Triple> tripleIterator = triples.iterator();
        Triple triple = tripleIterator.hasNext() ? tripleIterator.next() : null;
        return this.parse(semAct, str2 -> TestSemanticActionPlugin.resolveTripleVar(str2, triple));
    }

    private boolean parse(SemAct semAct, ExtractVar extractor) {
        String code = semAct.getCode();
        if (code == null) {
            throw new RuntimeException(String.format("%s semantic action should not be null", SemActIri));
        }
        Matcher m = ParsePattern.matcher(code);
        if (!m.find()) {
            throw new RuntimeException(String.format("%s semantic action %s did not match %s", SemActIri, code, ParsePattern));
        }
        String function = m.group(1);
        String argument = m.group(2);
        ArrayList<String> printed = new ArrayList<String>();
        while ((m = LeadPattern.matcher(argument)).find()) {
            printed.add(extractor.run(m.group(1)));
            argument = argument.substring(m.end());
        }
        m = LastPattern.matcher(argument);
        m.find();
        printed.add(extractor.run(m.group(1)));
        this.out.add(String.join((CharSequence)", ", printed));
        return !function.equals("fail");
    }

    private static String resolveStartVar(String varName) {
        if (varName.charAt(0) == '\"') {
            return varName.replaceAll("\\\\(.)", "$1");
        }
        throw new RuntimeException(String.format("%s semantic action argument %s was not a literal", SemActIri, varName));
    }

    private static String resolveNodeVar(String varName, Node focus) {
        Node pos;
        if (varName.charAt(0) == '\"') {
            return varName.replaceAll("\\\\(.)", "$1");
        }
        switch (varName) {
            case "s": {
                pos = focus;
                break;
            }
            default: {
                throw new RuntimeException(String.format("%s semantic action argument %s was not literal or 's', 'p', or 'o'", SemActIri, varName));
            }
        }
        return pos.toString();
    }

    private static String resolveTripleVar(String varName, Triple triple) {
        Node pos;
        if (varName.charAt(0) == '\"') {
            return varName.replaceAll("\\\\(.)", "$1");
        }
        if (triple == null) {
            return null;
        }
        switch (varName) {
            case "s": {
                pos = triple.getSubject();
                break;
            }
            case "p": {
                pos = triple.getPredicate();
                break;
            }
            case "o": {
                pos = triple.getObject();
                break;
            }
            default: {
                throw new RuntimeException(String.format("%s semantic action argument %s was not a literal or 's', 'p', or 'o'", SemActIri, varName));
            }
        }
        return pos.toString();
    }

    static {
        String term = "(\\\"(?:(?:[^\\\\\\\"]|\\\\[^\\\"])+)\\\"|[spo])";
        ParsePattern = Pattern.compile("^ *(fail|print) *\\(((?:" + term + ", )*" + term + ")\\) *$");
        LeadPattern = Pattern.compile(term + ", ");
        LastPattern = Pattern.compile("((" + term + "))");
        ParsePatter1 = Pattern.compile("^ *(fail|print) *\\((\\\"(?:(?:[^\\\\\\\"]|\\\\[^\\\"])+)\\\"|[spo])\\) *$");
    }
}

