/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.event.AbstractConstraintEvaluationEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnFocusNodeWithCompareNodesEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnFocusNodeWithSingleCompareNodeEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnPathNodesWithCompareNodesEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnSinglePathNodeWithCompareNodesEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnSinglePathNodeWithSingleCompareNodeEvent;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.path.Path;

public abstract class ConstraintPairwise
implements Constraint {
    protected final Node value;
    private final Node constraintComponent;

    protected ConstraintPairwise(Node value, Node constraintComponent) {
        this.value = value;
        this.constraintComponent = constraintComponent;
    }

    public Node getValue() {
        return this.value;
    }

    @Override
    public final Node getComponent() {
        return this.constraintComponent;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        this.validatePropertyShape(vCxt, data, shape, focusNode, null, Collections.singleton(focusNode));
    }

    @Override
    public final void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> pathNodes) {
        Set<Node> compareNodes = G.allSP(data, focusNode, this.value);
        this.validate(vCxt, shape, focusNode, path, pathNodes, compareNodes);
    }

    protected AbstractConstraintEvaluationEvent makeEventSingleCompareNode(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Node valueNode, Node compareNode, boolean isValid) {
        if (valueNode.equals(focusNode)) {
            return new ConstraintEvaluatedOnFocusNodeWithSingleCompareNodeEvent(vCxt, shape, focusNode, this, compareNode, isValid);
        }
        return new ConstraintEvaluatedOnSinglePathNodeWithSingleCompareNodeEvent(vCxt, shape, focusNode, this, path, valueNode, compareNode, isValid);
    }

    protected AbstractConstraintEvaluationEvent makeEvent(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Set<Node> compareNodes, boolean isValid) {
        if (pathNodes.size() == 1 && pathNodes.contains(focusNode)) {
            return new ConstraintEvaluatedOnFocusNodeWithCompareNodesEvent(vCxt, shape, focusNode, this, compareNodes, isValid);
        }
        return new ConstraintEvaluatedOnPathNodesWithCompareNodesEvent(vCxt, shape, focusNode, this, path, pathNodes, compareNodes, isValid);
    }

    protected AbstractConstraintEvaluationEvent makeEventSinglePathNode(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Node pathNode, Set<Node> compareNodes, boolean isValid) {
        if (pathNode.equals(focusNode)) {
            return new ConstraintEvaluatedOnFocusNodeWithCompareNodesEvent(vCxt, shape, focusNode, this, compareNodes, isValid);
        }
        return new ConstraintEvaluatedOnSinglePathNodeWithCompareNodesEvent(vCxt, shape, focusNode, this, path, pathNode, compareNodes, isValid);
    }

    public abstract void validate(ValidationContext var1, Shape var2, Node var3, Path var4, Set<Node> var5, Set<Node> var6);

    protected int compare(Node n1, Node n2) {
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        try {
            return NodeValue.compare(nv1, nv2);
        }
        catch (ExprNotComparableException ex) {
            return -999;
        }
    }

    public int hashCode() {
        return Objects.hash(this.constraintComponent, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintPairwise other = (ConstraintPairwise)obj;
        return Objects.equals(this.constraintComponent, other.constraintComponent) && Objects.equals(this.value, other.value);
    }
}

