/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.constraint.SparqlConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SparqlConstraints {
    public static Constraint parseSparqlConstraint(Graph shapesGraph, Node shape, Node p, Node sparqlConstraintNode) {
        Node message = G.getZeroOrOneSP(shapesGraph, sparqlConstraintNode, SHACL.message);
        boolean deactivated = SparqlConstraints.absentOrOne(shapesGraph, sparqlConstraintNode, SHACL.deactivated, NodeConst.nodeTrue);
        Query query2 = ShLib.extractSPARQLQuery(shapesGraph, sparqlConstraintNode);
        String msg = message != null && message.isLiteral() ? message.getLiteralLexicalForm() : null;
        return new SparqlConstraint(query2, msg);
    }

    private static boolean absentOrOne(Graph g, Node s, Node p, Node o) {
        try (ExtendedIterator<Triple> iter = G.find(g, s, p, null);){
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            iter.next();
            if (!iter.hasNext()) {
                boolean bl = true;
                return bl;
            }
            long x = Iter.count(G.find(g, s, p, null));
            throw new ShaclParseException("More than one (" + x + ") of " + String.format("(%s %s %s)", s, p, o));
        }
    }
}

