/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfNQuad;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import com.apicatalog.rdf.RdfValue;
import com.apicatalog.rdf.spi.RdfProvider;
import java.util.Optional;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.NodeUtils;

public class JenaTitanium {
    public static RdfDataset convert(DatasetGraph dataset) {
        RdfProvider provider = RdfProvider.provider();
        RdfDataset rdfDataset = provider.createDataset();
        NodeToLabel labelMapping = NodeToLabel.createScopeByDocument();
        dataset.find().forEachRemaining(quad -> {
            RdfResource subject = JenaTitanium.resource(provider, labelMapping, quad.getSubject());
            RdfResource predicate = JenaTitanium.resource(provider, labelMapping, quad.getPredicate());
            RdfValue object = JenaTitanium.nodeToValue(provider, labelMapping, quad.getObject());
            if (quad.isDefaultGraph()) {
                RdfTriple t = provider.createTriple(subject, predicate, object);
                rdfDataset.add(t);
            } else {
                RdfNQuad q = provider.createNQuad(subject, predicate, object, JenaTitanium.resource(provider, labelMapping, quad.getGraph()));
                rdfDataset.add(q);
            }
        });
        return rdfDataset;
    }

    public static DatasetGraph convert(RdfDataset dataset) {
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        StreamRDF dest = StreamRDFLib.dataset(dsg);
        JenaTitanium.convert(dataset, dest);
        return dsg;
    }

    public static void convert(RdfDataset dataset, StreamRDF output) {
        JenaTitanium.convert(dataset, RiotLib.factoryRDF(), output);
    }

    public static void convert(RdfDataset dataset, FactoryRDF factory, StreamRDF output) {
        RdfProvider provider = RdfProvider.provider();
        for (RdfNQuad rdfQuad : dataset.toList()) {
            Optional<RdfResource> gn = rdfQuad.getGraphName();
            RdfResource subj = rdfQuad.getSubject();
            RdfResource pred = rdfQuad.getPredicate();
            RdfValue obj = rdfQuad.getObject();
            Node g = JenaTitanium.valueToNode(factory, gn);
            Node s = JenaTitanium.valueToNode(factory, subj);
            Node p = JenaTitanium.valueToNode(factory, pred);
            Node o = JenaTitanium.valueToNode(factory, obj);
            if (g == null) {
                output.triple(Triple.create(s, p, o));
                continue;
            }
            output.quad(Quad.create(g, s, p, o));
        }
    }

    private static Node valueToNode(FactoryRDF factory, Optional<RdfResource> value) {
        if (value.isEmpty()) {
            return null;
        }
        return JenaTitanium.valueToNode(factory, value.get());
    }

    private static Node valueToNode(FactoryRDF factory, RdfValue value) {
        if (value.isBlankNode()) {
            return factory.createBlankNode(value.getValue());
        }
        if (value.isIRI()) {
            return factory.createURI(value.getValue());
        }
        if (value.isLiteral()) {
            RdfLiteral literal = (RdfLiteral)value;
            String lex = literal.getValue();
            String dt = literal.getDatatype();
            RDFDatatype datatype = NodeFactory.getType(dt);
            Optional<String> lang = literal.getLanguage();
            if (lang.isPresent()) {
                return factory.createLangLiteral(lex, lang.get());
            }
            return factory.createTypedLiteral(lex, datatype);
        }
        throw new JenaTitaniumException("Not recognized: " + value);
    }

    private static RdfResource resource(RdfProvider provider, NodeToLabel labelMapping, Node node) {
        if (node.isBlank()) {
            String s = (String)labelMapping.get(null, node);
            return provider.createBlankNode(s);
        }
        if (node.isURI()) {
            return provider.createIRI(node.getURI());
        }
        throw new JenaTitaniumException("Can not convert to an RdfResource : " + node);
    }

    private static RdfValue nodeToValue(RdfProvider provider, NodeToLabel labelMapping, Node node) {
        if (node.isBlank() || node.isURI()) {
            return JenaTitanium.resource(provider, labelMapping, node);
        }
        if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            if (NodeUtils.hasLang(node)) {
                return provider.createLangString(lex, node.getLiteralLanguage());
            }
            return provider.createTypedString(lex, node.getLiteralDatatypeURI());
        }
        throw new JenaTitaniumException("Can not be converted: " + node);
    }

    public static class JenaTitaniumException
    extends JenaException {
        public JenaTitaniumException(String msg) {
            super(msg);
        }
    }
}

