/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.metrics.FusekiRequestsMetrics;
import org.apache.jena.fuseki.metrics.MetricsProvider;
import org.apache.jena.fuseki.metrics.SimpleMetricsProvider;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;

public class MetricsProviderRegistry {
    private static int priority = Integer.MAX_VALUE;
    private static MetricsProvider metricsProvider = new SimpleMetricsProvider();

    public static MetricsProvider get() {
        return metricsProvider;
    }

    public static void put(MetricsProvider metricsProvider, int priority) {
        if (priority < MetricsProviderRegistry.priority) {
            MetricsProviderRegistry.priority = priority;
            MetricsProviderRegistry.metricsProvider = metricsProvider;
        }
    }

    public static void bindPrometheus(DataAccessPointRegistry dapRegistry) {
        try {
            MeterRegistry meterRegistry = MetricsProviderRegistry.get().getMeterRegistry();
            if (meterRegistry != null) {
                dapRegistry.accessPoints().forEach(dap -> new FusekiRequestsMetrics((DataAccessPoint)dap).bindTo(meterRegistry));
            }
        }
        catch (Throwable th) {
            Fuseki.configLog.error("Failed to bind all data access points to Prometheus", th);
        }
    }
}

