/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.cmd;

import org.apache.jena.atlas.io.IO;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.fuseki.cmd.FusekiArgs;
import org.apache.jena.fuseki.system.spot.TDBOps;

class WebappDSGSetup {
    WebappDSGSetup() {
    }

    static void setup(String directory, boolean useTDB2, FusekiArgs cmdLineConfig) {
        if (!IO.exists(directory)) {
            throw new CmdException("Does not exist: " + directory);
        }
        if (!IO.isDirectory(directory)) {
            throw new CmdException("Not a directory: " + directory);
        }
        if (IO.isEmptyDirectory(directory)) {
            if (useTDB2) {
                WebappDSGSetup.setupTDB2(directory, cmdLineConfig);
            } else {
                WebappDSGSetup.setupTDB1(directory, cmdLineConfig);
            }
            return;
        }
        if (TDBOps.isTDB1(directory)) {
            WebappDSGSetup.setupTDB1(directory, cmdLineConfig);
            return;
        }
        if (TDBOps.isTDB2(directory)) {
            WebappDSGSetup.setupTDB2(directory, cmdLineConfig);
            return;
        }
        throw new CmdException("Directory not a database: " + directory);
    }

    private static void setupTDB1(String directory, FusekiArgs cmdLineConfig) {
        cmdLineConfig.params.put("DIR", directory);
        cmdLineConfig.templateFile = cmdLineConfig.allowUpdate ? "templates/config-tdb-dir" : "templates/config-tdb-dir-readonly";
        cmdLineConfig.datasetDescription = "TDB1 dataset: location=" + directory;
    }

    private static void setupTDB2(String directory, FusekiArgs cmdLineConfig) {
        cmdLineConfig.params.put("DIR", directory);
        cmdLineConfig.templateFile = cmdLineConfig.allowUpdate ? "templates/config-tdb2-dir" : "templates/config-tdb2-dir-readonly";
        cmdLineConfig.datasetDescription = "TDB2 dataset: location=" + directory;
    }
}

