/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.authz;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.jena.fuseki.authz.AuthorizationFilter403;

public class LocalhostFilter
extends AuthorizationFilter403 {
    private static final String message = "Access denied : only localhost access allowed";
    private static String LOCALHOST_IpV6_a = "[0:0:0:0:0:0:0:1]";
    private static String LOCALHOST_IpV6_b = "0:0:0:0:0:0:0:1";
    private static String LOCALHOST_IpV6_c = "[::1]";
    private static String LOCALHOST_IpV4 = "127.0.0.1";
    private static final Collection<String> localhosts = Set.copyOf(Arrays.asList(LOCALHOST_IpV4, LOCALHOST_IpV6_a, LOCALHOST_IpV6_b, LOCALHOST_IpV6_c));

    public LocalhostFilter() {
        super(message);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return localhosts.contains(request.getRemoteAddr());
    }
}

