/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.observation;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.Observation;
import java.util.stream.Collectors;

public class DefaultMeterObservationHandler
implements MeterObservationHandler<Observation.Context> {
    private final MeterRegistry meterRegistry;

    public DefaultMeterObservationHandler(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onStart(Observation.Context context2) {
        LongTaskTimer.Sample longTaskSample = LongTaskTimer.builder(context2.getName() + ".active").tags(this.createTags(context2)).register(this.meterRegistry).start();
        context2.put(LongTaskTimer.Sample.class, longTaskSample);
        Timer.Sample sample = Timer.start(this.meterRegistry);
        context2.put(Timer.Sample.class, sample);
    }

    @Override
    public void onStop(Observation.Context context2) {
        Timer.Sample sample = (Timer.Sample)context2.getRequired(Timer.Sample.class);
        sample.stop(((Timer.Builder)((Timer.Builder)Timer.builder(context2.getName()).tags((Iterable)this.createErrorTags(context2))).tags((Iterable)this.createTags(context2))).register(this.meterRegistry));
        LongTaskTimer.Sample longTaskSample = (LongTaskTimer.Sample)context2.getRequired(LongTaskTimer.Sample.class);
        longTaskSample.stop();
    }

    @Override
    public void onEvent(Observation.Event event, Observation.Context context2) {
        Counter.builder(context2.getName() + "." + event.getName()).tags(this.createTags(context2)).register(this.meterRegistry).increment();
    }

    private Tags createErrorTags(Observation.Context context2) {
        return Tags.of("error", this.getErrorValue(context2));
    }

    private String getErrorValue(Observation.Context context2) {
        Throwable error = context2.getError();
        return error != null ? error.getClass().getSimpleName() : "none";
    }

    private Tags createTags(Observation.Context context2) {
        return Tags.of(context2.getLowCardinalityKeyValues().stream().map(tag -> Tag.of(tag.getKey(), tag.getValue())).collect(Collectors.toList()));
    }
}

