/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.json.JsonProvider;
import com.apicatalog.jsonld.serialization.RefJsonObject;
import com.apicatalog.rdf.RdfLiteral;
import com.apicatalog.rdf.RdfValue;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.StringReader;

final class RdfToObject {
    private RdfValue value;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean useNativeTypes;
    private JsonLdVersion processingMode;

    private RdfToObject(RdfValue object, JsonLdOptions.RdfDirection rdfDirection, boolean useNativeTypes) {
        this.value = object;
        this.rdfDirection = rdfDirection;
        this.useNativeTypes = useNativeTypes;
        this.processingMode = JsonLdVersion.V1_1;
    }

    public static final RdfToObject with(RdfValue object, JsonLdOptions.RdfDirection rdfDirection, boolean useNativeTypes) {
        return new RdfToObject(object, rdfDirection, useNativeTypes);
    }

    public RdfToObject processingMode(JsonLdVersion processingMode) {
        this.processingMode = processingMode;
        return this;
    }

    public JsonObject build() throws JsonLdError {
        String type;
        JsonValue convertedValue;
        RdfLiteral literal;
        JsonObjectBuilder result;
        block37: {
            if (this.value.isIRI() || this.value.isBlankNode()) {
                return new RefJsonObject(JsonProvider.instance().createObjectBuilder().add("@id", this.value.getValue()).build());
            }
            result = JsonProvider.instance().createObjectBuilder();
            literal = this.value.asLiteral();
            convertedValue = null;
            type = null;
            if (this.useNativeTypes) {
                if (literal.getDatatype() != null) {
                    if ("http://www.w3.org/2001/XMLSchema#string".equals(literal.getDatatype())) {
                        convertedValue = JsonProvider.instance().createValue(literal.getValue());
                    } else if ("http://www.w3.org/2001/XMLSchema#boolean".equals(literal.getDatatype())) {
                        if ("true".equalsIgnoreCase(literal.getValue())) {
                            convertedValue = JsonValue.TRUE;
                        } else if ("false".equalsIgnoreCase(literal.getValue())) {
                            convertedValue = JsonValue.FALSE;
                        } else {
                            type = "http://www.w3.org/2001/XMLSchema#boolean";
                        }
                    } else if ("http://www.w3.org/2001/XMLSchema#integer".equals(literal.getDatatype()) || "http://www.w3.org/2001/XMLSchema#int".equals(literal.getDatatype()) || "http://www.w3.org/2001/XMLSchema#long".equals(literal.getDatatype())) {
                        convertedValue = JsonProvider.instance().createValue(Long.parseLong(literal.getValue()));
                    } else if ("http://www.w3.org/2001/XMLSchema#double".equals(literal.getDatatype())) {
                        convertedValue = JsonProvider.instance().createValue(Double.parseDouble(literal.getValue()));
                    } else if (literal.getDatatype() != null) {
                        type = literal.getDatatype();
                    }
                }
            } else {
                if (this.processingMode != JsonLdVersion.V1_0 && literal.getDatatype() != null && "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON".equals(literal.getDatatype())) {
                    try (JsonParser parser = JsonProvider.instance().createParser(new StringReader(literal.getValue()));){
                        parser.next();
                        convertedValue = parser.getValue();
                        type = "@json";
                        break block37;
                    }
                    catch (Exception e2) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_JSON_LITERAL, (Throwable)e2);
                    }
                }
                if (JsonLdOptions.RdfDirection.I18N_DATATYPE == this.rdfDirection && literal.getDatatype() != null && literal.getDatatype().startsWith("https://www.w3.org/ns/i18n#")) {
                    convertedValue = JsonProvider.instance().createValue(literal.getValue());
                    String langId = literal.getDatatype().substring("https://www.w3.org/ns/i18n#".length());
                    int directionIndex = langId.indexOf(95);
                    if (directionIndex > 1) {
                        result.add("@language", JsonProvider.instance().createValue(langId.substring(0, directionIndex)));
                        result.add("@direction", JsonProvider.instance().createValue(langId.substring(directionIndex + 1)));
                    } else if (directionIndex == 0) {
                        result.add("@direction", JsonProvider.instance().createValue(langId.substring(1)));
                    } else if (directionIndex == -1) {
                        result.add("@language", JsonProvider.instance().createValue(langId));
                    }
                } else if (literal.getLanguage().isPresent()) {
                    literal.getLanguage().map(Json::createValue).ifPresent(language -> result.add("@language", (JsonValue)language));
                } else if (literal.getDatatype() != null && !"http://www.w3.org/2001/XMLSchema#string".equals(literal.getDatatype())) {
                    type = literal.getDatatype();
                }
            }
        }
        result.add("@value", convertedValue != null ? convertedValue : JsonProvider.instance().createValue(literal.getValue()));
        if (type != null) {
            result.add("@type", JsonProvider.instance().createValue(type));
        }
        return result.build();
    }
}

