/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.graph.GraphTokenStreamFiniteStrings;

public class QueryBuilder {
    protected Analyzer analyzer;
    protected boolean enablePositionIncrements = true;
    protected boolean enableGraphQueries = true;
    protected boolean autoGenerateMultiTermSynonymsPhraseQuery = false;

    public QueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Query createBooleanQuery(String field, String queryText) {
        return this.createBooleanQuery(field, queryText, BooleanClause.Occur.SHOULD);
    }

    public Query createBooleanQuery(String field, String queryText, BooleanClause.Occur operator) {
        if (operator != BooleanClause.Occur.SHOULD && operator != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("invalid operator: only SHOULD or MUST are allowed");
        }
        return this.createFieldQuery(this.analyzer, operator, field, queryText, false, 0);
    }

    public Query createPhraseQuery(String field, String queryText) {
        return this.createPhraseQuery(field, queryText, 0);
    }

    public Query createPhraseQuery(String field, String queryText, int phraseSlop) {
        return this.createFieldQuery(this.analyzer, BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
    }

    public Query createMinShouldMatchQuery(String field, String queryText, float fraction) {
        if (Float.isNaN(fraction) || fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("fraction should be >= 0 and <= 1");
        }
        if (fraction == 1.0f) {
            return this.createBooleanQuery(field, queryText, BooleanClause.Occur.MUST);
        }
        Query query2 = this.createFieldQuery(this.analyzer, BooleanClause.Occur.SHOULD, field, queryText, false, 0);
        if (query2 instanceof BooleanQuery) {
            query2 = this.addMinShouldMatchToBoolean((BooleanQuery)query2, fraction);
        }
        return query2;
    }

    private BooleanQuery addMinShouldMatchToBoolean(BooleanQuery query2, float fraction) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setMinimumNumberShouldMatch((int)(fraction * (float)query2.clauses().size()));
        for (BooleanClause clause : query2) {
            builder.add(clause);
        }
        return builder.build();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }

    public boolean getAutoGenerateMultiTermSynonymsPhraseQuery() {
        return this.autoGenerateMultiTermSynonymsPhraseQuery;
    }

    public void setAutoGenerateMultiTermSynonymsPhraseQuery(boolean enable) {
        this.autoGenerateMultiTermSynonymsPhraseQuery = enable;
    }

    protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
        Query query2;
        block9: {
            assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
            TokenStream source = analyzer.tokenStream(field, queryText);
            try {
                query2 = this.createFieldQuery(source, operator, field, quoted, phraseSlop);
                if (source == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException("Error analyzing query text", e2);
                }
            }
            source.close();
        }
        return query2;
    }

    public void setEnableGraphQueries(boolean v) {
        this.enableGraphQueries = v;
    }

    public boolean getEnableGraphQueries() {
        return this.enableGraphQueries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Query createFieldQuery(TokenStream source, BooleanClause.Occur operator, String field, boolean quoted, int phraseSlop) {
        assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
        try (CachingTokenFilter stream = new CachingTokenFilter(source);){
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncAtt = stream.addAttribute(PositionIncrementAttribute.class);
            PositionLengthAttribute posLenAtt = stream.addAttribute(PositionLengthAttribute.class);
            if (termAtt == null) {
                Query query2 = null;
                return query2;
            }
            int numTokens = 0;
            int positionCount = 0;
            boolean hasSynonyms = false;
            boolean isGraph = false;
            stream.reset();
            while (stream.incrementToken()) {
                ++numTokens;
                int positionIncrement = posIncAtt.getPositionIncrement();
                if (positionIncrement != 0) {
                    positionCount += positionIncrement;
                } else {
                    hasSynonyms = true;
                }
                int positionLength = posLenAtt.getPositionLength();
                if (!this.enableGraphQueries || positionLength <= 1) continue;
                isGraph = true;
            }
            if (numTokens == 0) {
                Query query3 = null;
                return query3;
            }
            if (numTokens == 1) {
                Query query4 = this.analyzeTerm(field, stream);
                return query4;
            }
            if (isGraph) {
                if (quoted) {
                    Query query5 = this.analyzeGraphPhrase(stream, field, phraseSlop);
                    return query5;
                }
                Query query6 = this.analyzeGraphBoolean(field, stream, operator);
                return query6;
            }
            if (quoted && positionCount > 1) {
                if (hasSynonyms) {
                    Query query7 = this.analyzeMultiPhrase(field, stream, phraseSlop);
                    return query7;
                }
                Query query8 = this.analyzePhrase(field, stream, phraseSlop);
                return query8;
            }
            if (positionCount == 1) {
                Query query9 = this.analyzeBoolean(field, stream);
                return query9;
            }
            Query query10 = this.analyzeMultiBoolean(field, stream, operator);
            return query10;
        }
        catch (IOException e2) {
            throw new RuntimeException("Error analyzing query text", e2);
        }
    }

    protected Query analyzeTerm(String field, TokenStream stream) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        BoostAttribute boostAtt = stream.addAttribute(BoostAttribute.class);
        stream.reset();
        if (!stream.incrementToken()) {
            throw new AssertionError();
        }
        return this.newTermQuery(new Term(field, termAtt.getBytesRef()), boostAtt.getBoost());
    }

    protected Query analyzeBoolean(String field, TokenStream stream) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        BoostAttribute boostAtt = stream.addAttribute(BoostAttribute.class);
        stream.reset();
        ArrayList<TermAndBoost> terms = new ArrayList<TermAndBoost>();
        while (stream.incrementToken()) {
            terms.add(new TermAndBoost(new Term(field, termAtt.getBytesRef()), boostAtt.getBoost()));
        }
        return this.newSynonymQuery(terms.toArray(new TermAndBoost[0]));
    }

    protected void add(BooleanQuery.Builder q, List<TermAndBoost> current, BooleanClause.Occur operator) {
        if (current.isEmpty()) {
            return;
        }
        if (current.size() == 1) {
            q.add(this.newTermQuery(current.get((int)0).term, current.get((int)0).boost), operator);
        } else {
            q.add(this.newSynonymQuery(current.toArray(new TermAndBoost[0])), operator);
        }
    }

    protected Query analyzeMultiBoolean(String field, TokenStream stream, BooleanClause.Occur operator) throws IOException {
        BooleanQuery.Builder q = this.newBooleanQuery();
        ArrayList<TermAndBoost> currentQuery = new ArrayList<TermAndBoost>();
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        BoostAttribute boostAtt = stream.addAttribute(BoostAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                this.add(q, currentQuery, operator);
                currentQuery.clear();
            }
            currentQuery.add(new TermAndBoost(new Term(field, termAtt.getBytesRef()), boostAtt.getBoost()));
        }
        this.add(q, currentQuery, operator);
        return q.build();
    }

    protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        BoostAttribute boostAtt = stream.addAttribute(BoostAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        float phraseBoost = 1.0f;
        stream.reset();
        while (stream.incrementToken()) {
            position = this.enablePositionIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
            builder.add(new Term(field, termAtt.getBytesRef()), position);
            phraseBoost *= boostAtt.getBoost();
        }
        PhraseQuery query2 = builder.build();
        if (phraseBoost == 1.0f) {
            return query2;
        }
        return new BoostQuery(query2, phraseBoost);
    }

    protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
        MultiPhraseQuery.Builder mpqb = this.newMultiPhraseQueryBuilder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (this.enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (this.enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    protected Query analyzeGraphBoolean(final String field, TokenStream source, BooleanClause.Occur operator) throws IOException {
        source.reset();
        GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        int[] articulationPoints = graph.articulationPoints();
        int lastState = 0;
        for (int i = 0; i <= articulationPoints.length; ++i) {
            Query positionalQuery;
            int start = lastState;
            int end = -1;
            if (i < articulationPoints.length) {
                end = articulationPoints[i];
            }
            lastState = end;
            if (graph.hasSidePath(start)) {
                final Iterator<TokenStream> sidePathsIterator = graph.getFiniteStrings(start, end);
                Iterator<Query> queries = new Iterator<Query>(){

                    @Override
                    public boolean hasNext() {
                        return sidePathsIterator.hasNext();
                    }

                    @Override
                    public Query next() {
                        TokenStream sidePath = (TokenStream)sidePathsIterator.next();
                        return QueryBuilder.this.createFieldQuery(sidePath, BooleanClause.Occur.MUST, field, QueryBuilder.this.getAutoGenerateMultiTermSynonymsPhraseQuery(), 0);
                    }
                };
                positionalQuery = this.newGraphSynonymQuery(queries);
            } else {
                List<AttributeSource> attributes = graph.getTerms(start);
                TermAndBoost[] terms = (TermAndBoost[])attributes.stream().map(s -> {
                    TermToBytesRefAttribute t = s.addAttribute(TermToBytesRefAttribute.class);
                    BoostAttribute b = s.addAttribute(BoostAttribute.class);
                    return new TermAndBoost(new Term(field, t.getBytesRef()), b.getBoost());
                }).toArray(TermAndBoost[]::new);
                assert (terms.length > 0);
                positionalQuery = terms.length == 1 ? this.newTermQuery(terms[0].term, terms[0].boost) : this.newSynonymQuery(terms);
            }
            if (positionalQuery == null) continue;
            builder.add(positionalQuery, operator);
        }
        return builder.build();
    }

    protected Query analyzeGraphPhrase(TokenStream source, String field, int phraseSlop) throws IOException {
        source.reset();
        GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        Iterator<TokenStream> it = graph.getFiniteStrings();
        while (it.hasNext()) {
            Query query2 = this.createFieldQuery(it.next(), BooleanClause.Occur.MUST, field, true, phraseSlop);
            if (query2 == null) continue;
            builder.add(query2, BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    protected BooleanQuery.Builder newBooleanQuery() {
        return new BooleanQuery.Builder();
    }

    protected Query newSynonymQuery(TermAndBoost[] terms) {
        SynonymQuery.Builder builder = new SynonymQuery.Builder(terms[0].term.field());
        for (TermAndBoost t : terms) {
            builder.addTerm(t.term, t.boost);
        }
        return builder.build();
    }

    protected Query newGraphSynonymQuery(Iterator<Query> queries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        while (queries.hasNext()) {
            builder.add(queries.next(), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery bq = builder.build();
        if (bq.clauses().size() == 1) {
            return bq.clauses().get(0).getQuery();
        }
        return bq;
    }

    protected Query newTermQuery(Term term, float boost) {
        TermQuery q = new TermQuery(term);
        if (boost == 1.0f) {
            return q;
        }
        return new BoostQuery(q, boost);
    }

    protected MultiPhraseQuery.Builder newMultiPhraseQueryBuilder() {
        return new MultiPhraseQuery.Builder();
    }

    public static class TermAndBoost {
        public final Term term;
        public final float boost;

        public TermAndBoost(Term term, float boost) {
            this.term = term;
            this.boost = boost;
        }
    }
}

