/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.Weight;

public class IndexSortSortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;
    private final Query fallbackQuery;

    public IndexSortSortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue, Query fallbackQuery) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        this.fallbackQuery = fallbackQuery;
    }

    public Query getFallbackQuery() {
        return this.fallbackQuery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSortSortedNumericDocValuesRangeQuery that = (IndexSortSortedNumericDocValuesRangeQuery)o;
        return this.lowerValue == that.lowerValue && this.upperValue == that.upperValue && Objects.equals(this.field, that.field) && Objects.equals(this.fallbackQuery, that.fallbackQuery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.lowerValue, this.upperValue, this.fallbackQuery);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
            this.fallbackQuery.visit(visitor);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        Query rewrittenFallback = this.fallbackQuery.rewrite(reader);
        if (rewrittenFallback.getClass() == MatchAllDocsQuery.class) {
            return new MatchAllDocsQuery();
        }
        if (rewrittenFallback == this.fallbackQuery) {
            return this;
        }
        return new IndexSortSortedNumericDocValuesRangeQuery(this.field, this.lowerValue, this.upperValue, rewrittenFallback);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight fallbackWeight = this.fallbackQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                final 1 weight = this;
                final BoundedDocIdSetIterator disi = IndexSortSortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNull(context2);
                if (disi != null) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, disi);
                        }

                        @Override
                        public long cost() {
                            return disi.cost();
                        }
                    };
                }
                return fallbackWeight.scorerSupplier(context2);
            }

            @Override
            public Scorer scorer(LeafReaderContext context2) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context2);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return fallbackWeight.isCacheable(ctx);
            }

            @Override
            public int count(LeafReaderContext context2) throws IOException {
                BoundedDocIdSetIterator disi;
                if (!context2.reader().hasDeletions() && (disi = IndexSortSortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNull(context2)) != null && disi.delegate == null) {
                    return disi.lastDoc - disi.firstDoc;
                }
                return fallbackWeight.count(context2);
            }
        };
    }

    private BoundedDocIdSetIterator getDocIdSetIteratorOrNull(LeafReaderContext context2) throws IOException {
        SortField sortField;
        SortField.Type sortFieldType;
        Sort indexSort;
        SortedNumericDocValues sortedNumericValues = DocValues.getSortedNumeric(context2.reader(), this.field);
        NumericDocValues numericValues = DocValues.unwrapSingleton(sortedNumericValues);
        if (numericValues != null && (indexSort = context2.reader().getMetaData().getSort()) != null && indexSort.getSort().length > 0 && indexSort.getSort()[0].getField().equals(this.field) && ((sortFieldType = IndexSortSortedNumericDocValuesRangeQuery.getSortFieldType(sortField = indexSort.getSort()[0])) == SortField.Type.INT || sortFieldType == SortField.Type.LONG)) {
            return this.getDocIdSetIterator(sortField, sortFieldType, context2, numericValues);
        }
        return null;
    }

    private BoundedDocIdSetIterator getDocIdSetIterator(SortField sortField, SortField.Type sortFieldType, LeafReaderContext context2, DocIdSetIterator delegate) throws IOException {
        long lower = sortField.getReverse() ? this.upperValue : this.lowerValue;
        long upper = sortField.getReverse() ? this.lowerValue : this.upperValue;
        int maxDoc = context2.reader().maxDoc();
        ValueComparator comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, lower, context2);
        int low = 0;
        int high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) <= 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, lower, context2);
                continue;
            }
            low = mid + 1;
        }
        int firstDocIdInclusive = high + 1;
        comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, upper, context2);
        low = firstDocIdInclusive;
        high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) < 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, upper, context2);
                continue;
            }
            low = mid + 1;
        }
        int lastDocIdExclusive = high + 1;
        Object missingValue = sortField.getMissingValue();
        LeafReader reader = context2.reader();
        PointValues pointValues = reader.getPointValues(this.field);
        long missingLongValue = missingValue == null ? 0L : (Long)missingValue;
        BoundedDocIdSetIterator disi = pointValues != null && pointValues.getDocCount() == reader.maxDoc() || missingLongValue < this.lowerValue || missingLongValue > this.upperValue ? new BoundedDocIdSetIterator(firstDocIdInclusive, lastDocIdExclusive, null) : new BoundedDocIdSetIterator(firstDocIdInclusive, lastDocIdExclusive, delegate);
        return disi;
    }

    private static ValueComparator loadComparator(SortField sortField, SortField.Type type, long topValue, LeafReaderContext context2) throws IOException {
        FieldComparator<?> fieldComparator = sortField.getComparator(1, false);
        if (type == SortField.Type.INT) {
            fieldComparator.setTopValue((int)topValue);
        } else {
            fieldComparator.setTopValue(topValue);
        }
        LeafFieldComparator leafFieldComparator = fieldComparator.getLeafComparator(context2);
        int direction = sortField.getReverse() ? -1 : 1;
        return doc -> {
            int value = leafFieldComparator.compareTop(doc);
            return direction * value;
        };
    }

    private static SortField.Type getSortFieldType(SortField sortField) {
        if (sortField instanceof SortedNumericSortField) {
            return ((SortedNumericSortField)sortField).getNumericType();
        }
        return sortField.getType();
    }

    private static class BoundedDocIdSetIterator
    extends DocIdSetIterator {
        private final int firstDoc;
        private final int lastDoc;
        private final DocIdSetIterator delegate;
        private int docID = -1;

        BoundedDocIdSetIterator(int firstDoc, int lastDoc, DocIdSetIterator delegate) {
            this.firstDoc = firstDoc;
            this.lastDoc = lastDoc;
            this.delegate = delegate;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target < this.firstDoc) {
                target = this.firstDoc;
            }
            int result = this.delegate != null ? this.delegate.advance(target) : target;
            this.docID = result < this.lastDoc ? result : Integer.MAX_VALUE;
            return this.docID;
        }

        @Override
        public long cost() {
            return this.lastDoc - this.firstDoc;
        }
    }

    private static interface ValueComparator {
        public int compare(int var1) throws IOException;
    }
}

