/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;

public abstract class VectorValues
extends DocIdSetIterator {
    public static final int MAX_DIMENSIONS = 1024;
    public static final VectorValues EMPTY = new VectorValues(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int dimension() {
            return 0;
        }

        @Override
        public float[] vectorValue() {
            throw new IllegalStateException("Attempt to get vectors from EMPTY values (which was not advanced)");
        }

        @Override
        public int docID() {
            throw new IllegalStateException("VectorValues is EMPTY, and not positioned on a doc");
        }

        @Override
        public int nextDoc() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) {
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return 0L;
        }
    };

    protected VectorValues() {
    }

    public abstract int dimension();

    public abstract int size();

    public abstract float[] vectorValue() throws IOException;

    public BytesRef binaryValue() throws IOException {
        throw new UnsupportedOperationException();
    }

    public static class SortingVectorValues
    extends VectorValues {
        private final RandomAccessVectorValues randomAccess;
        private final int[] docIdOffsets;
        private int docId = -1;

        SortingVectorValues(VectorValues delegate, Sorter.DocMap sortMap) throws IOException {
            int docID;
            this.randomAccess = ((RandomAccessVectorValues)((Object)delegate)).copy();
            this.docIdOffsets = new int[sortMap.size()];
            int offset = 1;
            while ((docID = delegate.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                this.docIdOffsets[newDocID] = offset++;
            }
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() throws IOException {
            while (this.docId < this.docIdOffsets.length - 1) {
                ++this.docId;
                if (this.docIdOffsets[this.docId] == 0) continue;
                return this.docId;
            }
            this.docId = Integer.MAX_VALUE;
            return this.docId;
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            return this.randomAccess.binaryValue(this.docIdOffsets[this.docId] - 1);
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.randomAccess.vectorValue(this.docIdOffsets[this.docId] - 1);
        }

        @Override
        public int dimension() {
            return this.randomAccess.dimension();
        }

        @Override
        public int size() {
            return this.randomAccess.size();
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.size();
        }
    }
}

