/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene92;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsReader;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.DirectMonotonicReader;

abstract class OffHeapVectorValues
extends VectorValues
implements RandomAccessVectorValues {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final BytesRef binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;
    protected final float[] value;

    OffHeapVectorValues(int dimension, int size, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = 4 * dimension;
        this.byteBuffer = ByteBuffer.allocate(this.byteSize);
        this.value = new float[dimension];
        this.binaryValue = new BytesRef(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long cost() {
        return this.size;
    }

    @Override
    public float[] vectorValue(int targetOrd) throws IOException {
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readFloats(this.value, 0, this.value.length);
        return this.value;
    }

    @Override
    public BytesRef binaryValue(int targetOrd) throws IOException {
        this.readValue(targetOrd);
        return this.binaryValue;
    }

    private void readValue(int targetOrd) throws IOException {
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
    }

    public abstract int ordToDoc(int var1);

    static OffHeapVectorValues load(Lucene92HnswVectorsReader.FieldEntry fieldEntry, IndexInput vectorData) throws IOException {
        if (fieldEntry.docsWithFieldOffset == -2L) {
            return new EmptyOffHeapVectorValues(fieldEntry.dimension);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        if (fieldEntry.docsWithFieldOffset == -1L) {
            return new DenseOffHeapVectorValues(fieldEntry.dimension, fieldEntry.size, bytesSlice);
        }
        return new SparseOffHeapVectorValues(fieldEntry, vectorData, bytesSlice);
    }

    abstract Bits getAcceptOrds(Bits var1);

    private static class EmptyOffHeapVectorValues
    extends OffHeapVectorValues {
        private int doc = -1;

        public EmptyOffHeapVectorValues(int dimension) {
            super(dimension, 0, null);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public float[] vectorValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public long cost() {
            return 0L;
        }

        @Override
        public RandomAccessVectorValues copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef binaryValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final Lucene92HnswVectorsReader.FieldEntry fieldEntry;

        public SparseOffHeapVectorValues(Lucene92HnswVectorsReader.FieldEntry fieldEntry, IndexInput dataIn, IndexInput slice) throws IOException {
            super(fieldEntry.dimension, fieldEntry.size, slice);
            this.fieldEntry = fieldEntry;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(fieldEntry.addressesOffset, fieldEntry.addressesLength);
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(fieldEntry.meta, addressesData);
            this.disi = new IndexedDISI(dataIn, fieldEntry.docsWithFieldOffset, fieldEntry.docsWithFieldLength, fieldEntry.jumpTableEntryCount, fieldEntry.denseRankPower, fieldEntry.size);
        }

        @Override
        public float[] vectorValue() throws IOException {
            this.slice.seek((long)this.disi.index() * (long)this.byteSize);
            this.slice.readFloats(this.value, 0, this.value.length);
            return this.value;
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            this.slice.seek((long)this.disi.index() * (long)this.byteSize);
            this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize, false);
            return this.binaryValue;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            return this.disi.advance(target);
        }

        @Override
        public RandomAccessVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.fieldEntry, this.dataIn, this.slice.clone());
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapVectorValues {
        private int doc = -1;

        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice) {
            super(dimension, size, slice);
        }

        @Override
        public float[] vectorValue() throws IOException {
            this.slice.seek((long)this.doc * (long)this.byteSize);
            this.slice.readFloats(this.value, 0, this.value.length);
            return this.value;
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            this.slice.seek((long)this.doc * (long)this.byteSize);
            this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize, false);
            return this.binaryValue;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            if (target >= this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public RandomAccessVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone());
        }

        @Override
        public int ordToDoc(int ord) {
            return ord;
        }

        @Override
        Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }
    }
}

